/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeleteSpaceRequest
implements Validatable {
    private final Boolean async;
    private final String spaceId;

    DeleteSpaceRequest(Boolean async, String spaceId) {
        this.async = async;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static DeleteSpaceRequestBuilder builder() {
        return new DeleteSpaceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteSpaceRequest)) {
            return false;
        }
        DeleteSpaceRequest other = (DeleteSpaceRequest)o;
        Boolean this$async = this.getAsync();
        Boolean other$async = other.getAsync();
        if (this$async == null ? other$async != null : !((Object)this$async).equals(other$async)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $async = this.getAsync();
        result = result * 59 + ($async == null ? 43 : ((Object)$async).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "DeleteSpaceRequest(async=" + this.getAsync() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @QueryParameter(value="async")
    public Boolean getAsync() {
        return this.async;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class DeleteSpaceRequestBuilder {
        private Boolean async;
        private String spaceId;

        DeleteSpaceRequestBuilder() {
        }

        public DeleteSpaceRequestBuilder async(Boolean async) {
            this.async = async;
            return this;
        }

        public DeleteSpaceRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public DeleteSpaceRequest build() {
            return new DeleteSpaceRequest(this.async, this.spaceId);
        }

        public String toString() {
            return "DeleteSpaceRequest.DeleteSpaceRequestBuilder(async=" + this.async + ", spaceId=" + this.spaceId + ")";
        }
    }
}

