/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstance;
import org.cloudfoundry.client.v2.spaces.SpaceApplicationSummary;

public final class GetSpaceSummaryResponse {
    private final List<SpaceApplicationSummary> applications;
    private final String id;
    private final String name;
    private final List<ServiceInstance> services;

    GetSpaceSummaryResponse(@JsonProperty(value="apps") List<SpaceApplicationSummary> applications, @JsonProperty(value="guid") String id, @JsonProperty(value="name") String name, @JsonProperty(value="services") List<ServiceInstance> services) {
        this.applications = applications;
        this.id = id;
        this.name = name;
        this.services = services;
    }

    public static GetSpaceSummaryResponseBuilder builder() {
        return new GetSpaceSummaryResponseBuilder();
    }

    public List<SpaceApplicationSummary> getApplications() {
        return this.applications;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ServiceInstance> getServices() {
        return this.services;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetSpaceSummaryResponse)) {
            return false;
        }
        GetSpaceSummaryResponse other = (GetSpaceSummaryResponse)o;
        List<SpaceApplicationSummary> this$applications = this.getApplications();
        List<SpaceApplicationSummary> other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !((Object)this$applications).equals(other$applications)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ServiceInstance> this$services = this.getServices();
        List<ServiceInstance> other$services = other.getServices();
        return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SpaceApplicationSummary> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : ((Object)$applications).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ServiceInstance> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        return result;
    }

    public String toString() {
        return "GetSpaceSummaryResponse(applications=" + this.getApplications() + ", id=" + this.getId() + ", name=" + this.getName() + ", services=" + this.getServices() + ")";
    }

    public static class GetSpaceSummaryResponseBuilder {
        private ArrayList<SpaceApplicationSummary> applications;
        private String id;
        private String name;
        private ArrayList<ServiceInstance> services;

        GetSpaceSummaryResponseBuilder() {
        }

        public GetSpaceSummaryResponseBuilder application(SpaceApplicationSummary application) {
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.add(application);
            return this;
        }

        public GetSpaceSummaryResponseBuilder applications(Collection<? extends SpaceApplicationSummary> applications) {
            if (this.applications == null) {
                this.applications = new ArrayList();
            }
            this.applications.addAll(applications);
            return this;
        }

        public GetSpaceSummaryResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public GetSpaceSummaryResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GetSpaceSummaryResponseBuilder service(ServiceInstance service) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.add(service);
            return this;
        }

        public GetSpaceSummaryResponseBuilder services(Collection<? extends ServiceInstance> services) {
            if (this.services == null) {
                this.services = new ArrayList();
            }
            this.services.addAll(services);
            return this;
        }

        public GetSpaceSummaryResponse build() {
            List<ServiceInstance> services;
            List<SpaceApplicationSummary> applications;
            switch (this.applications == null ? 0 : this.applications.size()) {
                case 0: {
                    applications = Collections.emptyList();
                    break;
                }
                case 1: {
                    applications = Collections.singletonList(this.applications.get(0));
                    break;
                }
                default: {
                    applications = Collections.unmodifiableList(new ArrayList<SpaceApplicationSummary>(this.applications));
                }
            }
            switch (this.services == null ? 0 : this.services.size()) {
                case 0: {
                    services = Collections.emptyList();
                    break;
                }
                case 1: {
                    services = Collections.singletonList(this.services.get(0));
                    break;
                }
                default: {
                    services = Collections.unmodifiableList(new ArrayList<ServiceInstance>(this.services));
                }
            }
            return new GetSpaceSummaryResponse(applications, this.id, this.name, services);
        }

        public String toString() {
            return "GetSpaceSummaryResponse.GetSpaceSummaryResponseBuilder(applications=" + this.applications + ", id=" + this.id + ", name=" + this.name + ", services=" + this.services + ")";
        }
    }
}

