/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.IsFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceApplicationsRequest
extends PaginatedRequest
implements Validatable {
    private final Boolean diego;
    private final List<String> names;
    private final List<String> organizationIds;
    private final String spaceId;
    private final List<String> stackIds;

    ListSpaceApplicationsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, Boolean diego, List<String> names, List<String> organizationIds, String spaceId, List<String> stackIds) {
        super(orderDirection, page, resultsPerPage);
        this.diego = diego;
        this.names = names;
        this.organizationIds = organizationIds;
        this.spaceId = spaceId;
        this.stackIds = stackIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceApplicationsRequestBuilder builder() {
        return new ListSpaceApplicationsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceApplicationsRequest)) {
            return false;
        }
        ListSpaceApplicationsRequest other = (ListSpaceApplicationsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$diego = this.getDiego();
        Boolean other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !((Object)this$diego).equals(other$diego)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        List<String> this$stackIds = this.getStackIds();
        List<String> other$stackIds = other.getStackIds();
        return !(this$stackIds == null ? other$stackIds != null : !((Object)this$stackIds).equals(other$stackIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceApplicationsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $diego = this.getDiego();
        result = result * 59 + ($diego == null ? 43 : ((Object)$diego).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        List<String> $stackIds = this.getStackIds();
        result = result * 59 + ($stackIds == null ? 43 : ((Object)$stackIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceApplicationsRequest(super=" + super.toString() + ", diego=" + this.getDiego() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", spaceId=" + this.getSpaceId() + ", stackIds=" + this.getStackIds() + ")";
    }

    @IsFilterParameter(value="diego")
    public Boolean getDiego() {
        return this.diego;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    @InFilterParameter(value="stack_guid")
    public List<String> getStackIds() {
        return this.stackIds;
    }

    public static class ListSpaceApplicationsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private Boolean diego;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private String spaceId;
        private ArrayList<String> stackIds;

        ListSpaceApplicationsRequestBuilder() {
        }

        public ListSpaceApplicationsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceApplicationsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceApplicationsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceApplicationsRequestBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public ListSpaceApplicationsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListSpaceApplicationsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListSpaceApplicationsRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListSpaceApplicationsRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListSpaceApplicationsRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceApplicationsRequestBuilder stackId(String stackId) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.add(stackId);
            return this;
        }

        public ListSpaceApplicationsRequestBuilder stackIds(Collection<? extends String> stackIds) {
            if (this.stackIds == null) {
                this.stackIds = new ArrayList();
            }
            this.stackIds.addAll(stackIds);
            return this;
        }

        public ListSpaceApplicationsRequest build() {
            List<String> stackIds;
            List<String> organizationIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.stackIds == null ? 0 : this.stackIds.size()) {
                case 0: {
                    stackIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    stackIds = Collections.singletonList(this.stackIds.get(0));
                    break;
                }
                default: {
                    stackIds = Collections.unmodifiableList(new ArrayList<String>(this.stackIds));
                }
            }
            return new ListSpaceApplicationsRequest(this.orderDirection, this.page, this.resultsPerPage, this.diego, names, organizationIds, this.spaceId, stackIds);
        }

        public String toString() {
            return "ListSpaceApplicationsRequest.ListSpaceApplicationsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", diego=" + this.diego + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceId=" + this.spaceId + ", stackIds=" + this.stackIds + ")";
        }
    }
}

