/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceAuditorsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> auditedOrganizationIds;
    private final List<String> auditedSpaceIds;
    private final List<String> billingManagedOrganizationIds;
    private final List<String> managedOrganizationIds;
    private final List<String> managedSpaceIds;
    private final List<String> organizationIds;
    private final String spaceId;

    ListSpaceAuditorsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> auditedOrganizationIds, List<String> auditedSpaceIds, List<String> billingManagedOrganizationIds, List<String> managedOrganizationIds, List<String> managedSpaceIds, List<String> organizationIds, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.auditedOrganizationIds = auditedOrganizationIds;
        this.auditedSpaceIds = auditedSpaceIds;
        this.billingManagedOrganizationIds = billingManagedOrganizationIds;
        this.managedOrganizationIds = managedOrganizationIds;
        this.managedSpaceIds = managedSpaceIds;
        this.organizationIds = organizationIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceAuditorsRequestBuilder builder() {
        return new ListSpaceAuditorsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceAuditorsRequest)) {
            return false;
        }
        ListSpaceAuditorsRequest other = (ListSpaceAuditorsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$auditedOrganizationIds = this.getAuditedOrganizationIds();
        List<String> other$auditedOrganizationIds = other.getAuditedOrganizationIds();
        if (this$auditedOrganizationIds == null ? other$auditedOrganizationIds != null : !((Object)this$auditedOrganizationIds).equals(other$auditedOrganizationIds)) {
            return false;
        }
        List<String> this$auditedSpaceIds = this.getAuditedSpaceIds();
        List<String> other$auditedSpaceIds = other.getAuditedSpaceIds();
        if (this$auditedSpaceIds == null ? other$auditedSpaceIds != null : !((Object)this$auditedSpaceIds).equals(other$auditedSpaceIds)) {
            return false;
        }
        List<String> this$billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        List<String> other$billingManagedOrganizationIds = other.getBillingManagedOrganizationIds();
        if (this$billingManagedOrganizationIds == null ? other$billingManagedOrganizationIds != null : !((Object)this$billingManagedOrganizationIds).equals(other$billingManagedOrganizationIds)) {
            return false;
        }
        List<String> this$managedOrganizationIds = this.getManagedOrganizationIds();
        List<String> other$managedOrganizationIds = other.getManagedOrganizationIds();
        if (this$managedOrganizationIds == null ? other$managedOrganizationIds != null : !((Object)this$managedOrganizationIds).equals(other$managedOrganizationIds)) {
            return false;
        }
        List<String> this$managedSpaceIds = this.getManagedSpaceIds();
        List<String> other$managedSpaceIds = other.getManagedSpaceIds();
        if (this$managedSpaceIds == null ? other$managedSpaceIds != null : !((Object)this$managedSpaceIds).equals(other$managedSpaceIds)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceAuditorsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $auditedOrganizationIds = this.getAuditedOrganizationIds();
        result = result * 59 + ($auditedOrganizationIds == null ? 43 : ((Object)$auditedOrganizationIds).hashCode());
        List<String> $auditedSpaceIds = this.getAuditedSpaceIds();
        result = result * 59 + ($auditedSpaceIds == null ? 43 : ((Object)$auditedSpaceIds).hashCode());
        List<String> $billingManagedOrganizationIds = this.getBillingManagedOrganizationIds();
        result = result * 59 + ($billingManagedOrganizationIds == null ? 43 : ((Object)$billingManagedOrganizationIds).hashCode());
        List<String> $managedOrganizationIds = this.getManagedOrganizationIds();
        result = result * 59 + ($managedOrganizationIds == null ? 43 : ((Object)$managedOrganizationIds).hashCode());
        List<String> $managedSpaceIds = this.getManagedSpaceIds();
        result = result * 59 + ($managedSpaceIds == null ? 43 : ((Object)$managedSpaceIds).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceAuditorsRequest(super=" + super.toString() + ", auditedOrganizationIds=" + this.getAuditedOrganizationIds() + ", auditedSpaceIds=" + this.getAuditedSpaceIds() + ", billingManagedOrganizationIds=" + this.getBillingManagedOrganizationIds() + ", managedOrganizationIds=" + this.getManagedOrganizationIds() + ", managedSpaceIds=" + this.getManagedSpaceIds() + ", organizationIds=" + this.getOrganizationIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="audited_organization_guid")
    public List<String> getAuditedOrganizationIds() {
        return this.auditedOrganizationIds;
    }

    @InFilterParameter(value="audited_space_guid")
    public List<String> getAuditedSpaceIds() {
        return this.auditedSpaceIds;
    }

    @InFilterParameter(value="billing_managed_organization_guid")
    public List<String> getBillingManagedOrganizationIds() {
        return this.billingManagedOrganizationIds;
    }

    @InFilterParameter(value="managed_organization_guid")
    public List<String> getManagedOrganizationIds() {
        return this.managedOrganizationIds;
    }

    @InFilterParameter(value="managed_space_guid")
    public List<String> getManagedSpaceIds() {
        return this.managedSpaceIds;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceAuditorsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> auditedOrganizationIds;
        private ArrayList<String> auditedSpaceIds;
        private ArrayList<String> billingManagedOrganizationIds;
        private ArrayList<String> managedOrganizationIds;
        private ArrayList<String> managedSpaceIds;
        private ArrayList<String> organizationIds;
        private String spaceId;

        ListSpaceAuditorsRequestBuilder() {
        }

        public ListSpaceAuditorsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceAuditorsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceAuditorsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceAuditorsRequestBuilder auditedOrganizationId(String auditedOrganizationId) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList();
            }
            this.auditedOrganizationIds.add(auditedOrganizationId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder auditedOrganizationIds(Collection<? extends String> auditedOrganizationIds) {
            if (this.auditedOrganizationIds == null) {
                this.auditedOrganizationIds = new ArrayList();
            }
            this.auditedOrganizationIds.addAll(auditedOrganizationIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder auditedSpaceId(String auditedSpaceId) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList();
            }
            this.auditedSpaceIds.add(auditedSpaceId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder auditedSpaceIds(Collection<? extends String> auditedSpaceIds) {
            if (this.auditedSpaceIds == null) {
                this.auditedSpaceIds = new ArrayList();
            }
            this.auditedSpaceIds.addAll(auditedSpaceIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder billingManagedOrganizationId(String billingManagedOrganizationId) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList();
            }
            this.billingManagedOrganizationIds.add(billingManagedOrganizationId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder billingManagedOrganizationIds(Collection<? extends String> billingManagedOrganizationIds) {
            if (this.billingManagedOrganizationIds == null) {
                this.billingManagedOrganizationIds = new ArrayList();
            }
            this.billingManagedOrganizationIds.addAll(billingManagedOrganizationIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder managedOrganizationId(String managedOrganizationId) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList();
            }
            this.managedOrganizationIds.add(managedOrganizationId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder managedOrganizationIds(Collection<? extends String> managedOrganizationIds) {
            if (this.managedOrganizationIds == null) {
                this.managedOrganizationIds = new ArrayList();
            }
            this.managedOrganizationIds.addAll(managedOrganizationIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder managedSpaceId(String managedSpaceId) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList();
            }
            this.managedSpaceIds.add(managedSpaceId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder managedSpaceIds(Collection<? extends String> managedSpaceIds) {
            if (this.managedSpaceIds == null) {
                this.managedSpaceIds = new ArrayList();
            }
            this.managedSpaceIds.addAll(managedSpaceIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListSpaceAuditorsRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceAuditorsRequest build() {
            List<String> organizationIds;
            List<String> managedSpaceIds;
            List<String> managedOrganizationIds;
            List<String> billingManagedOrganizationIds;
            List<String> auditedSpaceIds;
            List<String> auditedOrganizationIds;
            switch (this.auditedOrganizationIds == null ? 0 : this.auditedOrganizationIds.size()) {
                case 0: {
                    auditedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditedOrganizationIds = Collections.singletonList(this.auditedOrganizationIds.get(0));
                    break;
                }
                default: {
                    auditedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.auditedOrganizationIds));
                }
            }
            switch (this.auditedSpaceIds == null ? 0 : this.auditedSpaceIds.size()) {
                case 0: {
                    auditedSpaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    auditedSpaceIds = Collections.singletonList(this.auditedSpaceIds.get(0));
                    break;
                }
                default: {
                    auditedSpaceIds = Collections.unmodifiableList(new ArrayList<String>(this.auditedSpaceIds));
                }
            }
            switch (this.billingManagedOrganizationIds == null ? 0 : this.billingManagedOrganizationIds.size()) {
                case 0: {
                    billingManagedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    billingManagedOrganizationIds = Collections.singletonList(this.billingManagedOrganizationIds.get(0));
                    break;
                }
                default: {
                    billingManagedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.billingManagedOrganizationIds));
                }
            }
            switch (this.managedOrganizationIds == null ? 0 : this.managedOrganizationIds.size()) {
                case 0: {
                    managedOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managedOrganizationIds = Collections.singletonList(this.managedOrganizationIds.get(0));
                    break;
                }
                default: {
                    managedOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.managedOrganizationIds));
                }
            }
            switch (this.managedSpaceIds == null ? 0 : this.managedSpaceIds.size()) {
                case 0: {
                    managedSpaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    managedSpaceIds = Collections.singletonList(this.managedSpaceIds.get(0));
                    break;
                }
                default: {
                    managedSpaceIds = Collections.unmodifiableList(new ArrayList<String>(this.managedSpaceIds));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            return new ListSpaceAuditorsRequest(this.orderDirection, this.page, this.resultsPerPage, auditedOrganizationIds, auditedSpaceIds, billingManagedOrganizationIds, managedOrganizationIds, managedSpaceIds, organizationIds, this.spaceId);
        }

        public String toString() {
            return "ListSpaceAuditorsRequest.ListSpaceAuditorsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", auditedOrganizationIds=" + this.auditedOrganizationIds + ", auditedSpaceIds=" + this.auditedSpaceIds + ", billingManagedOrganizationIds=" + this.billingManagedOrganizationIds + ", managedOrganizationIds=" + this.managedOrganizationIds + ", managedSpaceIds=" + this.managedSpaceIds + ", organizationIds=" + this.organizationIds + ", spaceId=" + this.spaceId + ")";
        }
    }
}

