/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.users.UserResource;

public final class ListSpaceAuditorsResponse
extends PaginatedResponse<UserResource> {
    ListSpaceAuditorsResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<UserResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListSpaceAuditorsResponseBuilder builder() {
        return new ListSpaceAuditorsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceAuditorsResponse)) {
            return false;
        }
        ListSpaceAuditorsResponse other = (ListSpaceAuditorsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceAuditorsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceAuditorsResponse(super=" + super.toString() + ")";
    }

    public static class ListSpaceAuditorsResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<UserResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListSpaceAuditorsResponseBuilder() {
        }

        public ListSpaceAuditorsResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListSpaceAuditorsResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListSpaceAuditorsResponseBuilder resource(UserResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListSpaceAuditorsResponseBuilder resources(Collection<? extends UserResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListSpaceAuditorsResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListSpaceAuditorsResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSpaceAuditorsResponse build() {
            List<UserResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<UserResource>(this.resources));
                }
            }
            return new ListSpaceAuditorsResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListSpaceAuditorsResponse.ListSpaceAuditorsResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

