/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceDomainsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;
    private final List<String> owningOrganizationIds;
    private final String spaceId;

    ListSpaceDomainsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, List<String> owningOrganizationIds, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.owningOrganizationIds = owningOrganizationIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceDomainsRequestBuilder builder() {
        return new ListSpaceDomainsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceDomainsRequest)) {
            return false;
        }
        ListSpaceDomainsRequest other = (ListSpaceDomainsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$owningOrganizationIds = this.getOwningOrganizationIds();
        List<String> other$owningOrganizationIds = other.getOwningOrganizationIds();
        if (this$owningOrganizationIds == null ? other$owningOrganizationIds != null : !((Object)this$owningOrganizationIds).equals(other$owningOrganizationIds)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceDomainsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $owningOrganizationIds = this.getOwningOrganizationIds();
        result = result * 59 + ($owningOrganizationIds == null ? 43 : ((Object)$owningOrganizationIds).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceDomainsRequest(super=" + super.toString() + ", names=" + this.getNames() + ", owningOrganizationIds=" + this.getOwningOrganizationIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="owning_organization_guid")
    public List<String> getOwningOrganizationIds() {
        return this.owningOrganizationIds;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceDomainsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;
        private ArrayList<String> owningOrganizationIds;
        private String spaceId;

        ListSpaceDomainsRequestBuilder() {
        }

        public ListSpaceDomainsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceDomainsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceDomainsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceDomainsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListSpaceDomainsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListSpaceDomainsRequestBuilder owningOrganizationId(String owningOrganizationId) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList();
            }
            this.owningOrganizationIds.add(owningOrganizationId);
            return this;
        }

        public ListSpaceDomainsRequestBuilder owningOrganizationIds(Collection<? extends String> owningOrganizationIds) {
            if (this.owningOrganizationIds == null) {
                this.owningOrganizationIds = new ArrayList();
            }
            this.owningOrganizationIds.addAll(owningOrganizationIds);
            return this;
        }

        public ListSpaceDomainsRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceDomainsRequest build() {
            List<String> owningOrganizationIds;
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.owningOrganizationIds == null ? 0 : this.owningOrganizationIds.size()) {
                case 0: {
                    owningOrganizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    owningOrganizationIds = Collections.singletonList(this.owningOrganizationIds.get(0));
                    break;
                }
                default: {
                    owningOrganizationIds = Collections.unmodifiableList(new ArrayList<String>(this.owningOrganizationIds));
                }
            }
            return new ListSpaceDomainsRequest(this.orderDirection, this.page, this.resultsPerPage, names, owningOrganizationIds, this.spaceId);
        }

        public String toString() {
            return "ListSpaceDomainsRequest.ListSpaceDomainsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", owningOrganizationIds=" + this.owningOrganizationIds + ", spaceId=" + this.spaceId + ")";
        }
    }
}

