/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.GreaterThanOrEqualToFilterParameter;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceEventsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> actees;
    private final String spaceId;
    private final List<String> timestamps;
    private final List<String> types;

    ListSpaceEventsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> actees, String spaceId, List<String> timestamps, List<String> types) {
        super(orderDirection, page, resultsPerPage);
        this.actees = actees;
        this.spaceId = spaceId;
        this.timestamps = timestamps;
        this.types = types;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceEventsRequestBuilder builder() {
        return new ListSpaceEventsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceEventsRequest)) {
            return false;
        }
        ListSpaceEventsRequest other = (ListSpaceEventsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$actees = this.getActees();
        List<String> other$actees = other.getActees();
        if (this$actees == null ? other$actees != null : !((Object)this$actees).equals(other$actees)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        List<String> this$timestamps = this.getTimestamps();
        List<String> other$timestamps = other.getTimestamps();
        if (this$timestamps == null ? other$timestamps != null : !((Object)this$timestamps).equals(other$timestamps)) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceEventsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $actees = this.getActees();
        result = result * 59 + ($actees == null ? 43 : ((Object)$actees).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        List<String> $timestamps = this.getTimestamps();
        result = result * 59 + ($timestamps == null ? 43 : ((Object)$timestamps).hashCode());
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceEventsRequest(super=" + super.toString() + ", actees=" + this.getActees() + ", spaceId=" + this.getSpaceId() + ", timestamps=" + this.getTimestamps() + ", types=" + this.getTypes() + ")";
    }

    @InFilterParameter(value="actee")
    public List<String> getActees() {
        return this.actees;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    @GreaterThanOrEqualToFilterParameter(value="timestamp")
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    @InFilterParameter(value="type")
    public List<String> getTypes() {
        return this.types;
    }

    public static class ListSpaceEventsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> actees;
        private String spaceId;
        private ArrayList<String> timestamps;
        private ArrayList<String> types;

        ListSpaceEventsRequestBuilder() {
        }

        public ListSpaceEventsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceEventsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceEventsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceEventsRequestBuilder actee(String actee) {
            if (this.actees == null) {
                this.actees = new ArrayList();
            }
            this.actees.add(actee);
            return this;
        }

        public ListSpaceEventsRequestBuilder actees(Collection<? extends String> actees) {
            if (this.actees == null) {
                this.actees = new ArrayList();
            }
            this.actees.addAll(actees);
            return this;
        }

        public ListSpaceEventsRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceEventsRequestBuilder timestamp(String timestamp) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList();
            }
            this.timestamps.add(timestamp);
            return this;
        }

        public ListSpaceEventsRequestBuilder timestamps(Collection<? extends String> timestamps) {
            if (this.timestamps == null) {
                this.timestamps = new ArrayList();
            }
            this.timestamps.addAll(timestamps);
            return this;
        }

        public ListSpaceEventsRequestBuilder type(String type) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.add(type);
            return this;
        }

        public ListSpaceEventsRequestBuilder types(Collection<? extends String> types) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.addAll(types);
            return this;
        }

        public ListSpaceEventsRequest build() {
            List<String> types;
            List<String> timestamps;
            List<String> actees;
            switch (this.actees == null ? 0 : this.actees.size()) {
                case 0: {
                    actees = Collections.emptyList();
                    break;
                }
                case 1: {
                    actees = Collections.singletonList(this.actees.get(0));
                    break;
                }
                default: {
                    actees = Collections.unmodifiableList(new ArrayList<String>(this.actees));
                }
            }
            switch (this.timestamps == null ? 0 : this.timestamps.size()) {
                case 0: {
                    timestamps = Collections.emptyList();
                    break;
                }
                case 1: {
                    timestamps = Collections.singletonList(this.timestamps.get(0));
                    break;
                }
                default: {
                    timestamps = Collections.unmodifiableList(new ArrayList<String>(this.timestamps));
                }
            }
            switch (this.types == null ? 0 : this.types.size()) {
                case 0: {
                    types = Collections.emptyList();
                    break;
                }
                case 1: {
                    types = Collections.singletonList(this.types.get(0));
                    break;
                }
                default: {
                    types = Collections.unmodifiableList(new ArrayList<String>(this.types));
                }
            }
            return new ListSpaceEventsRequest(this.orderDirection, this.page, this.resultsPerPage, actees, this.spaceId, timestamps, types);
        }

        public String toString() {
            return "ListSpaceEventsRequest.ListSpaceEventsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actees=" + this.actees + ", spaceId=" + this.spaceId + ", timestamps=" + this.timestamps + ", types=" + this.types + ")";
        }
    }
}

