/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceRoutesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> domainIds;
    private final List<String> hosts;
    private final List<String> paths;
    private final String spaceId;

    ListSpaceRoutesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> domainIds, List<String> hosts, List<String> paths, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.domainIds = domainIds;
        this.hosts = hosts;
        this.paths = paths;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceRoutesRequestBuilder builder() {
        return new ListSpaceRoutesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceRoutesRequest)) {
            return false;
        }
        ListSpaceRoutesRequest other = (ListSpaceRoutesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$domainIds = this.getDomainIds();
        List<String> other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !((Object)this$domainIds).equals(other$domainIds)) {
            return false;
        }
        List<String> this$hosts = this.getHosts();
        List<String> other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !((Object)this$hosts).equals(other$hosts)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceRoutesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $domainIds = this.getDomainIds();
        result = result * 59 + ($domainIds == null ? 43 : ((Object)$domainIds).hashCode());
        List<String> $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : ((Object)$hosts).hashCode());
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceRoutesRequest(super=" + super.toString() + ", domainIds=" + this.getDomainIds() + ", hosts=" + this.getHosts() + ", paths=" + this.getPaths() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="domain_guid")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @InFilterParameter(value="host")
    public List<String> getHosts() {
        return this.hosts;
    }

    @InFilterParameter(value="path")
    public List<String> getPaths() {
        return this.paths;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceRoutesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> domainIds;
        private ArrayList<String> hosts;
        private ArrayList<String> paths;
        private String spaceId;

        ListSpaceRoutesRequestBuilder() {
        }

        public ListSpaceRoutesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceRoutesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceRoutesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceRoutesRequestBuilder domainId(String domainId) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.add(domainId);
            return this;
        }

        public ListSpaceRoutesRequestBuilder domainIds(Collection<? extends String> domainIds) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList();
            }
            this.domainIds.addAll(domainIds);
            return this;
        }

        public ListSpaceRoutesRequestBuilder host(String host) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.add(host);
            return this;
        }

        public ListSpaceRoutesRequestBuilder hosts(Collection<? extends String> hosts) {
            if (this.hosts == null) {
                this.hosts = new ArrayList();
            }
            this.hosts.addAll(hosts);
            return this;
        }

        public ListSpaceRoutesRequestBuilder path(String path) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.add(path);
            return this;
        }

        public ListSpaceRoutesRequestBuilder paths(Collection<? extends String> paths) {
            if (this.paths == null) {
                this.paths = new ArrayList();
            }
            this.paths.addAll(paths);
            return this;
        }

        public ListSpaceRoutesRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceRoutesRequest build() {
            List<String> paths;
            List<String> hosts;
            List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
                case 0: {
                    domainIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    domainIds = Collections.singletonList(this.domainIds.get(0));
                    break;
                }
                default: {
                    domainIds = Collections.unmodifiableList(new ArrayList<String>(this.domainIds));
                }
            }
            switch (this.hosts == null ? 0 : this.hosts.size()) {
                case 0: {
                    hosts = Collections.emptyList();
                    break;
                }
                case 1: {
                    hosts = Collections.singletonList(this.hosts.get(0));
                    break;
                }
                default: {
                    hosts = Collections.unmodifiableList(new ArrayList<String>(this.hosts));
                }
            }
            switch (this.paths == null ? 0 : this.paths.size()) {
                case 0: {
                    paths = Collections.emptyList();
                    break;
                }
                case 1: {
                    paths = Collections.singletonList(this.paths.get(0));
                    break;
                }
                default: {
                    paths = Collections.unmodifiableList(new ArrayList<String>(this.paths));
                }
            }
            return new ListSpaceRoutesRequest(this.orderDirection, this.page, this.resultsPerPage, domainIds, hosts, paths, this.spaceId);
        }

        public String toString() {
            return "ListSpaceRoutesRequest.ListSpaceRoutesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", paths=" + this.paths + ", spaceId=" + this.spaceId + ")";
        }
    }
}

