/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceSecurityGroupsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> names;
    private final String spaceId;

    ListSpaceSecurityGroupsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceSecurityGroupsRequestBuilder builder() {
        return new ListSpaceSecurityGroupsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceSecurityGroupsRequest)) {
            return false;
        }
        ListSpaceSecurityGroupsRequest other = (ListSpaceSecurityGroupsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceSecurityGroupsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceSecurityGroupsRequest(super=" + super.toString() + ", names=" + this.getNames() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceSecurityGroupsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> names;
        private String spaceId;

        ListSpaceSecurityGroupsRequestBuilder() {
        }

        public ListSpaceSecurityGroupsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceSecurityGroupsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceSecurityGroupsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceSecurityGroupsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListSpaceSecurityGroupsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListSpaceSecurityGroupsRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceSecurityGroupsRequest build() {
            List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            return new ListSpaceSecurityGroupsRequest(this.orderDirection, this.page, this.resultsPerPage, names, this.spaceId);
        }

        public String toString() {
            return "ListSpaceSecurityGroupsRequest.ListSpaceSecurityGroupsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", spaceId=" + this.spaceId + ")";
        }
    }
}

