/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceServiceInstancesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> gatewayNames;
    private final List<String> names;
    private final List<String> organizationIds;
    private final Boolean returnUserProvidedServiceInstances;
    private final List<String> serviceBindingIds;
    private final List<String> serviceKeyIds;
    private final List<String> servicePlanIds;
    private final String spaceId;

    ListSpaceServiceInstancesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> gatewayNames, List<String> names, List<String> organizationIds, Boolean returnUserProvidedServiceInstances, List<String> serviceBindingIds, List<String> serviceKeyIds, List<String> servicePlanIds, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.gatewayNames = gatewayNames;
        this.names = names;
        this.organizationIds = organizationIds;
        this.returnUserProvidedServiceInstances = returnUserProvidedServiceInstances;
        this.serviceBindingIds = serviceBindingIds;
        this.serviceKeyIds = serviceKeyIds;
        this.servicePlanIds = servicePlanIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceServiceInstancesRequestBuilder builder() {
        return new ListSpaceServiceInstancesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceServiceInstancesRequest)) {
            return false;
        }
        ListSpaceServiceInstancesRequest other = (ListSpaceServiceInstancesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$gatewayNames = this.getGatewayNames();
        List<String> other$gatewayNames = other.getGatewayNames();
        if (this$gatewayNames == null ? other$gatewayNames != null : !((Object)this$gatewayNames).equals(other$gatewayNames)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        Boolean this$returnUserProvidedServiceInstances = this.getReturnUserProvidedServiceInstances();
        Boolean other$returnUserProvidedServiceInstances = other.getReturnUserProvidedServiceInstances();
        if (this$returnUserProvidedServiceInstances == null ? other$returnUserProvidedServiceInstances != null : !((Object)this$returnUserProvidedServiceInstances).equals(other$returnUserProvidedServiceInstances)) {
            return false;
        }
        List<String> this$serviceBindingIds = this.getServiceBindingIds();
        List<String> other$serviceBindingIds = other.getServiceBindingIds();
        if (this$serviceBindingIds == null ? other$serviceBindingIds != null : !((Object)this$serviceBindingIds).equals(other$serviceBindingIds)) {
            return false;
        }
        List<String> this$serviceKeyIds = this.getServiceKeyIds();
        List<String> other$serviceKeyIds = other.getServiceKeyIds();
        if (this$serviceKeyIds == null ? other$serviceKeyIds != null : !((Object)this$serviceKeyIds).equals(other$serviceKeyIds)) {
            return false;
        }
        List<String> this$servicePlanIds = this.getServicePlanIds();
        List<String> other$servicePlanIds = other.getServicePlanIds();
        if (this$servicePlanIds == null ? other$servicePlanIds != null : !((Object)this$servicePlanIds).equals(other$servicePlanIds)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceServiceInstancesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $gatewayNames = this.getGatewayNames();
        result = result * 59 + ($gatewayNames == null ? 43 : ((Object)$gatewayNames).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        Boolean $returnUserProvidedServiceInstances = this.getReturnUserProvidedServiceInstances();
        result = result * 59 + ($returnUserProvidedServiceInstances == null ? 43 : ((Object)$returnUserProvidedServiceInstances).hashCode());
        List<String> $serviceBindingIds = this.getServiceBindingIds();
        result = result * 59 + ($serviceBindingIds == null ? 43 : ((Object)$serviceBindingIds).hashCode());
        List<String> $serviceKeyIds = this.getServiceKeyIds();
        result = result * 59 + ($serviceKeyIds == null ? 43 : ((Object)$serviceKeyIds).hashCode());
        List<String> $servicePlanIds = this.getServicePlanIds();
        result = result * 59 + ($servicePlanIds == null ? 43 : ((Object)$servicePlanIds).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceServiceInstancesRequest(super=" + super.toString() + ", gatewayNames=" + this.getGatewayNames() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", returnUserProvidedServiceInstances=" + this.getReturnUserProvidedServiceInstances() + ", serviceBindingIds=" + this.getServiceBindingIds() + ", serviceKeyIds=" + this.getServiceKeyIds() + ", servicePlanIds=" + this.getServicePlanIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="gateway_name")
    public List<String> getGatewayNames() {
        return this.gatewayNames;
    }

    @InFilterParameter(value="name")
    public List<String> getNames() {
        return this.names;
    }

    @InFilterParameter(value="organization_guid")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @QueryParameter(value="return_user_provided_service_instances")
    public Boolean getReturnUserProvidedServiceInstances() {
        return this.returnUserProvidedServiceInstances;
    }

    @InFilterParameter(value="service_binding_guid")
    public List<String> getServiceBindingIds() {
        return this.serviceBindingIds;
    }

    @InFilterParameter(value="service_key_guid")
    public List<String> getServiceKeyIds() {
        return this.serviceKeyIds;
    }

    @InFilterParameter(value="service_plan_guid")
    public List<String> getServicePlanIds() {
        return this.servicePlanIds;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceServiceInstancesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> gatewayNames;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private Boolean returnUserProvidedServiceInstances;
        private ArrayList<String> serviceBindingIds;
        private ArrayList<String> serviceKeyIds;
        private ArrayList<String> servicePlanIds;
        private String spaceId;

        ListSpaceServiceInstancesRequestBuilder() {
        }

        public ListSpaceServiceInstancesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder gatewayName(String gatewayName) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.add(gatewayName);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder gatewayNames(Collection<? extends String> gatewayNames) {
            if (this.gatewayNames == null) {
                this.gatewayNames = new ArrayList();
            }
            this.gatewayNames.addAll(gatewayNames);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder returnUserProvidedServiceInstances(Boolean returnUserProvidedServiceInstances) {
            this.returnUserProvidedServiceInstances = returnUserProvidedServiceInstances;
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder serviceBindingId(String serviceBindingId) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.add(serviceBindingId);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder serviceBindingIds(Collection<? extends String> serviceBindingIds) {
            if (this.serviceBindingIds == null) {
                this.serviceBindingIds = new ArrayList();
            }
            this.serviceBindingIds.addAll(serviceBindingIds);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder serviceKeyId(String serviceKeyId) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.add(serviceKeyId);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder serviceKeyIds(Collection<? extends String> serviceKeyIds) {
            if (this.serviceKeyIds == null) {
                this.serviceKeyIds = new ArrayList();
            }
            this.serviceKeyIds.addAll(serviceKeyIds);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder servicePlanId(String servicePlanId) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.add(servicePlanId);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder servicePlanIds(Collection<? extends String> servicePlanIds) {
            if (this.servicePlanIds == null) {
                this.servicePlanIds = new ArrayList();
            }
            this.servicePlanIds.addAll(servicePlanIds);
            return this;
        }

        public ListSpaceServiceInstancesRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceServiceInstancesRequest build() {
            List<String> servicePlanIds;
            List<String> serviceKeyIds;
            List<String> serviceBindingIds;
            List<String> organizationIds;
            List<String> names;
            List<String> gatewayNames;
            switch (this.gatewayNames == null ? 0 : this.gatewayNames.size()) {
                case 0: {
                    gatewayNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    gatewayNames = Collections.singletonList(this.gatewayNames.get(0));
                    break;
                }
                default: {
                    gatewayNames = Collections.unmodifiableList(new ArrayList<String>(this.gatewayNames));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.serviceBindingIds == null ? 0 : this.serviceBindingIds.size()) {
                case 0: {
                    serviceBindingIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBindingIds = Collections.singletonList(this.serviceBindingIds.get(0));
                    break;
                }
                default: {
                    serviceBindingIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBindingIds));
                }
            }
            switch (this.serviceKeyIds == null ? 0 : this.serviceKeyIds.size()) {
                case 0: {
                    serviceKeyIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceKeyIds = Collections.singletonList(this.serviceKeyIds.get(0));
                    break;
                }
                default: {
                    serviceKeyIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceKeyIds));
                }
            }
            switch (this.servicePlanIds == null ? 0 : this.servicePlanIds.size()) {
                case 0: {
                    servicePlanIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    servicePlanIds = Collections.singletonList(this.servicePlanIds.get(0));
                    break;
                }
                default: {
                    servicePlanIds = Collections.unmodifiableList(new ArrayList<String>(this.servicePlanIds));
                }
            }
            return new ListSpaceServiceInstancesRequest(this.orderDirection, this.page, this.resultsPerPage, gatewayNames, names, organizationIds, this.returnUserProvidedServiceInstances, serviceBindingIds, serviceKeyIds, servicePlanIds, this.spaceId);
        }

        public String toString() {
            return "ListSpaceServiceInstancesRequest.ListSpaceServiceInstancesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", gatewayNames=" + this.gatewayNames + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", returnUserProvidedServiceInstances=" + this.returnUserProvidedServiceInstances + ", serviceBindingIds=" + this.serviceBindingIds + ", serviceKeyIds=" + this.serviceKeyIds + ", servicePlanIds=" + this.servicePlanIds + ", spaceId=" + this.spaceId + ")";
        }
    }
}

