/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.serviceinstances.UnionServiceInstanceResource;

public final class ListSpaceServiceInstancesResponse
extends PaginatedResponse<UnionServiceInstanceResource> {
    ListSpaceServiceInstancesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<UnionServiceInstanceResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListSpaceServiceInstancesResponseBuilder builder() {
        return new ListSpaceServiceInstancesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceServiceInstancesResponse)) {
            return false;
        }
        ListSpaceServiceInstancesResponse other = (ListSpaceServiceInstancesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceServiceInstancesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceServiceInstancesResponse(super=" + super.toString() + ")";
    }

    public static class ListSpaceServiceInstancesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<UnionServiceInstanceResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListSpaceServiceInstancesResponseBuilder() {
        }

        public ListSpaceServiceInstancesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListSpaceServiceInstancesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListSpaceServiceInstancesResponseBuilder resource(UnionServiceInstanceResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListSpaceServiceInstancesResponseBuilder resources(Collection<? extends UnionServiceInstanceResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListSpaceServiceInstancesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListSpaceServiceInstancesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSpaceServiceInstancesResponse build() {
            List<UnionServiceInstanceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<UnionServiceInstanceResource>(this.resources));
                }
            }
            return new ListSpaceServiceInstancesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListSpaceServiceInstancesResponse.ListSpaceServiceInstancesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

