/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceServicesRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> actives;
    private final List<String> labels;
    private final List<String> providers;
    private final List<String> serviceBrokerIds;
    private final String spaceId;

    ListSpaceServicesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> actives, List<String> labels, List<String> providers, List<String> serviceBrokerIds, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.actives = actives;
        this.labels = labels;
        this.providers = providers;
        this.serviceBrokerIds = serviceBrokerIds;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceServicesRequestBuilder builder() {
        return new ListSpaceServicesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceServicesRequest)) {
            return false;
        }
        ListSpaceServicesRequest other = (ListSpaceServicesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$actives = this.getActives();
        List<String> other$actives = other.getActives();
        if (this$actives == null ? other$actives != null : !((Object)this$actives).equals(other$actives)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<String> this$providers = this.getProviders();
        List<String> other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers)) {
            return false;
        }
        List<String> this$serviceBrokerIds = this.getServiceBrokerIds();
        List<String> other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !((Object)this$serviceBrokerIds).equals(other$serviceBrokerIds)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceServicesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $actives = this.getActives();
        result = result * 59 + ($actives == null ? 43 : ((Object)$actives).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<String> $providers = this.getProviders();
        result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
        List<String> $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * 59 + ($serviceBrokerIds == null ? 43 : ((Object)$serviceBrokerIds).hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceServicesRequest(super=" + super.toString() + ", actives=" + this.getActives() + ", labels=" + this.getLabels() + ", providers=" + this.getProviders() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @InFilterParameter(value="active")
    public List<String> getActives() {
        return this.actives;
    }

    @InFilterParameter(value="label")
    public List<String> getLabels() {
        return this.labels;
    }

    @InFilterParameter(value="provider")
    public List<String> getProviders() {
        return this.providers;
    }

    @InFilterParameter(value="service_broker_guid")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceServicesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> actives;
        private ArrayList<String> labels;
        private ArrayList<String> providers;
        private ArrayList<String> serviceBrokerIds;
        private String spaceId;

        ListSpaceServicesRequestBuilder() {
        }

        public ListSpaceServicesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceServicesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceServicesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceServicesRequestBuilder active(String active) {
            if (this.actives == null) {
                this.actives = new ArrayList();
            }
            this.actives.add(active);
            return this;
        }

        public ListSpaceServicesRequestBuilder actives(Collection<? extends String> actives) {
            if (this.actives == null) {
                this.actives = new ArrayList();
            }
            this.actives.addAll(actives);
            return this;
        }

        public ListSpaceServicesRequestBuilder label(String label) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.add(label);
            return this;
        }

        public ListSpaceServicesRequestBuilder labels(Collection<? extends String> labels) {
            if (this.labels == null) {
                this.labels = new ArrayList();
            }
            this.labels.addAll(labels);
            return this;
        }

        public ListSpaceServicesRequestBuilder provider(String provider) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.add(provider);
            return this;
        }

        public ListSpaceServicesRequestBuilder providers(Collection<? extends String> providers) {
            if (this.providers == null) {
                this.providers = new ArrayList();
            }
            this.providers.addAll(providers);
            return this;
        }

        public ListSpaceServicesRequestBuilder serviceBrokerId(String serviceBrokerId) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        public ListSpaceServicesRequestBuilder serviceBrokerIds(Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) {
                this.serviceBrokerIds = new ArrayList();
            }
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        public ListSpaceServicesRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceServicesRequest build() {
            List<String> serviceBrokerIds;
            List<String> providers;
            List<String> labels;
            List<String> actives;
            switch (this.actives == null ? 0 : this.actives.size()) {
                case 0: {
                    actives = Collections.emptyList();
                    break;
                }
                case 1: {
                    actives = Collections.singletonList(this.actives.get(0));
                    break;
                }
                default: {
                    actives = Collections.unmodifiableList(new ArrayList<String>(this.actives));
                }
            }
            switch (this.labels == null ? 0 : this.labels.size()) {
                case 0: {
                    labels = Collections.emptyList();
                    break;
                }
                case 1: {
                    labels = Collections.singletonList(this.labels.get(0));
                    break;
                }
                default: {
                    labels = Collections.unmodifiableList(new ArrayList<String>(this.labels));
                }
            }
            switch (this.providers == null ? 0 : this.providers.size()) {
                case 0: {
                    providers = Collections.emptyList();
                    break;
                }
                case 1: {
                    providers = Collections.singletonList(this.providers.get(0));
                    break;
                }
                default: {
                    providers = Collections.unmodifiableList(new ArrayList<String>(this.providers));
                }
            }
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
                case 0: {
                    serviceBrokerIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceBrokerIds = Collections.singletonList(this.serviceBrokerIds.get(0));
                    break;
                }
                default: {
                    serviceBrokerIds = Collections.unmodifiableList(new ArrayList<String>(this.serviceBrokerIds));
                }
            }
            return new ListSpaceServicesRequest(this.orderDirection, this.page, this.resultsPerPage, actives, labels, providers, serviceBrokerIds, this.spaceId);
        }

        public String toString() {
            return "ListSpaceServicesRequest.ListSpaceServicesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actives=" + this.actives + ", labels=" + this.labels + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ", spaceId=" + this.spaceId + ")";
        }
    }
}

