/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListSpaceUserRolesRequest
extends PaginatedRequest
implements Validatable {
    private final String spaceId;

    ListSpaceUserRolesRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, String spaceId) {
        super(orderDirection, page, resultsPerPage);
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static ListSpaceUserRolesRequestBuilder builder() {
        return new ListSpaceUserRolesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceUserRolesRequest)) {
            return false;
        }
        ListSpaceUserRolesRequest other = (ListSpaceUserRolesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceUserRolesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceUserRolesRequest(super=" + super.toString() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class ListSpaceUserRolesRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private String spaceId;

        ListSpaceUserRolesRequestBuilder() {
        }

        public ListSpaceUserRolesRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListSpaceUserRolesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListSpaceUserRolesRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListSpaceUserRolesRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public ListSpaceUserRolesRequest build() {
            return new ListSpaceUserRolesRequest(this.orderDirection, this.page, this.resultsPerPage, this.spaceId);
        }

        public String toString() {
            return "ListSpaceUserRolesRequest.ListSpaceUserRolesRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", spaceId=" + this.spaceId + ")";
        }
    }
}

