/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.spaces.UserSpaceRoleResource;

public final class ListSpaceUserRolesResponse
extends PaginatedResponse<UserSpaceRoleResource> {
    ListSpaceUserRolesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<UserSpaceRoleResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListSpaceUserRolesResponseBuilder builder() {
        return new ListSpaceUserRolesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListSpaceUserRolesResponse)) {
            return false;
        }
        ListSpaceUserRolesResponse other = (ListSpaceUserRolesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListSpaceUserRolesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListSpaceUserRolesResponse(super=" + super.toString() + ")";
    }

    public static class ListSpaceUserRolesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<UserSpaceRoleResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListSpaceUserRolesResponseBuilder() {
        }

        public ListSpaceUserRolesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListSpaceUserRolesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListSpaceUserRolesResponseBuilder resource(UserSpaceRoleResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListSpaceUserRolesResponseBuilder resources(Collection<? extends UserSpaceRoleResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListSpaceUserRolesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListSpaceUserRolesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListSpaceUserRolesResponse build() {
            List<UserSpaceRoleResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<UserSpaceRoleResource>(this.resources));
                }
            }
            return new ListSpaceUserRolesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListSpaceUserRolesResponse.ListSpaceUserRolesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

