/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class RemoveSpaceDeveloperRequest
implements Validatable {
    private final String developerId;
    private final String spaceId;

    RemoveSpaceDeveloperRequest(String developerId, String spaceId) {
        this.developerId = developerId;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.developerId == null) {
            builder.message("developer id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static RemoveSpaceDeveloperRequestBuilder builder() {
        return new RemoveSpaceDeveloperRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSpaceDeveloperRequest)) {
            return false;
        }
        RemoveSpaceDeveloperRequest other = (RemoveSpaceDeveloperRequest)o;
        String this$developerId = this.getDeveloperId();
        String other$developerId = other.getDeveloperId();
        if (this$developerId == null ? other$developerId != null : !this$developerId.equals(other$developerId)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        return !(this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $developerId = this.getDeveloperId();
        result = result * 59 + ($developerId == null ? 43 : $developerId.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveSpaceDeveloperRequest(developerId=" + this.getDeveloperId() + ", spaceId=" + this.getSpaceId() + ")";
    }

    @JsonIgnore
    public String getDeveloperId() {
        return this.developerId;
    }

    @JsonIgnore
    public String getSpaceId() {
        return this.spaceId;
    }

    public static class RemoveSpaceDeveloperRequestBuilder {
        private String developerId;
        private String spaceId;

        RemoveSpaceDeveloperRequestBuilder() {
        }

        public RemoveSpaceDeveloperRequestBuilder developerId(String developerId) {
            this.developerId = developerId;
            return this;
        }

        public RemoveSpaceDeveloperRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public RemoveSpaceDeveloperRequest build() {
            return new RemoveSpaceDeveloperRequest(this.developerId, this.spaceId);
        }

        public String toString() {
            return "RemoveSpaceDeveloperRequest.RemoveSpaceDeveloperRequestBuilder(developerId=" + this.developerId + ", spaceId=" + this.spaceId + ")";
        }
    }
}

