/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.v2.applications.AbstractApplicationEntity;
import org.cloudfoundry.client.v2.routes.Route;

public final class SpaceApplicationSummary
extends AbstractApplicationEntity {
    private final String detectedBuildpack;
    private final Boolean enableSsh;
    private final String id;
    private final String packageState;
    private final String packageUpdatedAt;
    private final List<Integer> ports;
    private final List<Route> routes;
    private final Integer runningInstances;
    private final Integer serviceCount;
    private final List<String> serviceNames;
    private final String stagingTaskId;
    private final List<String> urls;
    private final String version;

    SpaceApplicationSummary(@JsonProperty(value="buildpack") String buildpack, @JsonProperty(value="command") String command, @JsonProperty(value="console") @Deprecated Boolean console, @JsonProperty(value="debug") @Deprecated Boolean debug, @JsonProperty(value="detected_buildpack") String detectedBuildpack, @JsonProperty(value="detected_start_command") String detectedStartCommand, @JsonProperty(value="diego") Boolean diego, @JsonProperty(value="disk_quota") Integer diskQuota, @JsonProperty(value="docker_credentials_json") Map<String, Object> dockerCredentialsJsons, @JsonProperty(value="docker_image") String dockerImage, @JsonProperty(value="enable_ssh") Boolean enableSsh, @JsonProperty(value="environment_json") Map<String, Object> environmentJsons, @JsonProperty(value="health_check_timeout") Integer healthCheckTimeout, @JsonProperty(value="health_check_type") String healthCheckType, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="memory") Integer memory, @JsonProperty(value="name") String name, @JsonProperty(value="package_state") String packageState, @JsonProperty(value="package_updated_at") String packageUpdatedAt, @JsonProperty(value="production") @Deprecated Boolean production, @JsonProperty(value="space_guid") String spaceId, @JsonProperty(value="stack_guid") String stackId, @JsonProperty(value="staging_failed_description") String stagingFailedDescription, @JsonProperty(value="staging_failed_reason") String stagingFailedReason, @JsonProperty(value="staging_task_id") String stagingTaskId, @JsonProperty(value="state") String state, @JsonProperty(value="version") String version, @JsonProperty(value="guid") String id, @JsonProperty(value="ports") List<Integer> ports, @JsonProperty(value="routes") List<Route> routes, @JsonProperty(value="running_instances") Integer runningInstances, @JsonProperty(value="service_count") Integer serviceCount, @JsonProperty(value="service_names") List<String> serviceNames, @JsonProperty(value="urls") List<String> urls) {
        super(buildpack, command, console, debug, detectedStartCommand, diego, diskQuota, dockerCredentialsJsons, dockerImage, environmentJsons, healthCheckTimeout, healthCheckType, instances, memory, name, production, spaceId, stackId, stagingFailedDescription, stagingFailedReason, state);
        this.detectedBuildpack = detectedBuildpack;
        this.enableSsh = enableSsh;
        this.id = id;
        this.packageState = packageState;
        this.packageUpdatedAt = packageUpdatedAt;
        this.ports = ports;
        this.routes = routes;
        this.runningInstances = runningInstances;
        this.serviceCount = serviceCount;
        this.serviceNames = serviceNames;
        this.stagingTaskId = stagingTaskId;
        this.urls = urls;
        this.version = version;
    }

    public static SpaceApplicationSummaryBuilder builder() {
        return new SpaceApplicationSummaryBuilder();
    }

    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    public String getId() {
        return this.id;
    }

    public String getPackageState() {
        return this.packageState;
    }

    public String getPackageUpdatedAt() {
        return this.packageUpdatedAt;
    }

    public List<Integer> getPorts() {
        return this.ports;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public Integer getRunningInstances() {
        return this.runningInstances;
    }

    public Integer getServiceCount() {
        return this.serviceCount;
    }

    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    public String getStagingTaskId() {
        return this.stagingTaskId;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpaceApplicationSummary)) {
            return false;
        }
        SpaceApplicationSummary other = (SpaceApplicationSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$detectedBuildpack = this.getDetectedBuildpack();
        String other$detectedBuildpack = other.getDetectedBuildpack();
        if (this$detectedBuildpack == null ? other$detectedBuildpack != null : !this$detectedBuildpack.equals(other$detectedBuildpack)) {
            return false;
        }
        Boolean this$enableSsh = this.getEnableSsh();
        Boolean other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !((Object)this$enableSsh).equals(other$enableSsh)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$packageState = this.getPackageState();
        String other$packageState = other.getPackageState();
        if (this$packageState == null ? other$packageState != null : !this$packageState.equals(other$packageState)) {
            return false;
        }
        String this$packageUpdatedAt = this.getPackageUpdatedAt();
        String other$packageUpdatedAt = other.getPackageUpdatedAt();
        if (this$packageUpdatedAt == null ? other$packageUpdatedAt != null : !this$packageUpdatedAt.equals(other$packageUpdatedAt)) {
            return false;
        }
        List<Integer> this$ports = this.getPorts();
        List<Integer> other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !((Object)this$ports).equals(other$ports)) {
            return false;
        }
        List<Route> this$routes = this.getRoutes();
        List<Route> other$routes = other.getRoutes();
        if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
            return false;
        }
        Integer this$runningInstances = this.getRunningInstances();
        Integer other$runningInstances = other.getRunningInstances();
        if (this$runningInstances == null ? other$runningInstances != null : !((Object)this$runningInstances).equals(other$runningInstances)) {
            return false;
        }
        Integer this$serviceCount = this.getServiceCount();
        Integer other$serviceCount = other.getServiceCount();
        if (this$serviceCount == null ? other$serviceCount != null : !((Object)this$serviceCount).equals(other$serviceCount)) {
            return false;
        }
        List<String> this$serviceNames = this.getServiceNames();
        List<String> other$serviceNames = other.getServiceNames();
        if (this$serviceNames == null ? other$serviceNames != null : !((Object)this$serviceNames).equals(other$serviceNames)) {
            return false;
        }
        String this$stagingTaskId = this.getStagingTaskId();
        String other$stagingTaskId = other.getStagingTaskId();
        if (this$stagingTaskId == null ? other$stagingTaskId != null : !this$stagingTaskId.equals(other$stagingTaskId)) {
            return false;
        }
        List<String> this$urls = this.getUrls();
        List<String> other$urls = other.getUrls();
        if (this$urls == null ? other$urls != null : !((Object)this$urls).equals(other$urls)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpaceApplicationSummary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $detectedBuildpack = this.getDetectedBuildpack();
        result = result * 59 + ($detectedBuildpack == null ? 43 : $detectedBuildpack.hashCode());
        Boolean $enableSsh = this.getEnableSsh();
        result = result * 59 + ($enableSsh == null ? 43 : ((Object)$enableSsh).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $packageState = this.getPackageState();
        result = result * 59 + ($packageState == null ? 43 : $packageState.hashCode());
        String $packageUpdatedAt = this.getPackageUpdatedAt();
        result = result * 59 + ($packageUpdatedAt == null ? 43 : $packageUpdatedAt.hashCode());
        List<Integer> $ports = this.getPorts();
        result = result * 59 + ($ports == null ? 43 : ((Object)$ports).hashCode());
        List<Route> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        Integer $runningInstances = this.getRunningInstances();
        result = result * 59 + ($runningInstances == null ? 43 : ((Object)$runningInstances).hashCode());
        Integer $serviceCount = this.getServiceCount();
        result = result * 59 + ($serviceCount == null ? 43 : ((Object)$serviceCount).hashCode());
        List<String> $serviceNames = this.getServiceNames();
        result = result * 59 + ($serviceNames == null ? 43 : ((Object)$serviceNames).hashCode());
        String $stagingTaskId = this.getStagingTaskId();
        result = result * 59 + ($stagingTaskId == null ? 43 : $stagingTaskId.hashCode());
        List<String> $urls = this.getUrls();
        result = result * 59 + ($urls == null ? 43 : ((Object)$urls).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpaceApplicationSummary(super=" + super.toString() + ", detectedBuildpack=" + this.getDetectedBuildpack() + ", enableSsh=" + this.getEnableSsh() + ", id=" + this.getId() + ", packageState=" + this.getPackageState() + ", packageUpdatedAt=" + this.getPackageUpdatedAt() + ", ports=" + this.getPorts() + ", routes=" + this.getRoutes() + ", runningInstances=" + this.getRunningInstances() + ", serviceCount=" + this.getServiceCount() + ", serviceNames=" + this.getServiceNames() + ", stagingTaskId=" + this.getStagingTaskId() + ", urls=" + this.getUrls() + ", version=" + this.getVersion() + ")";
    }

    public static class SpaceApplicationSummaryBuilder {
        private String buildpack;
        private String command;
        private Boolean console;
        private Boolean debug;
        private String detectedBuildpack;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private ArrayList<String> dockerCredentialsJsons$key;
        private ArrayList<Object> dockerCredentialsJsons$value;
        private String dockerImage;
        private Boolean enableSsh;
        private ArrayList<String> environmentJsons$key;
        private ArrayList<Object> environmentJsons$value;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private String packageState;
        private String packageUpdatedAt;
        private Boolean production;
        private String spaceId;
        private String stackId;
        private String stagingFailedDescription;
        private String stagingFailedReason;
        private String stagingTaskId;
        private String state;
        private String version;
        private String id;
        private ArrayList<Integer> ports;
        private ArrayList<Route> routes;
        private Integer runningInstances;
        private Integer serviceCount;
        private ArrayList<String> serviceNames;
        private ArrayList<String> urls;

        SpaceApplicationSummaryBuilder() {
        }

        public SpaceApplicationSummaryBuilder buildpack(String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        public SpaceApplicationSummaryBuilder command(String command) {
            this.command = command;
            return this;
        }

        public SpaceApplicationSummaryBuilder console(Boolean console) {
            this.console = console;
            return this;
        }

        public SpaceApplicationSummaryBuilder debug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public SpaceApplicationSummaryBuilder detectedBuildpack(String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
            return this;
        }

        public SpaceApplicationSummaryBuilder detectedStartCommand(String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        public SpaceApplicationSummaryBuilder diego(Boolean diego) {
            this.diego = diego;
            return this;
        }

        public SpaceApplicationSummaryBuilder diskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        public SpaceApplicationSummaryBuilder dockerCredentialsJson(String dockerCredentialsJsonKey, Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        public SpaceApplicationSummaryBuilder dockerCredentialsJsons(Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new ArrayList();
                this.dockerCredentialsJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SpaceApplicationSummaryBuilder dockerImage(String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public SpaceApplicationSummaryBuilder enableSsh(Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        public SpaceApplicationSummaryBuilder environmentJson(String environmentJsonKey, Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        public SpaceApplicationSummaryBuilder environmentJsons(Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new ArrayList();
                this.environmentJsons$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public SpaceApplicationSummaryBuilder healthCheckTimeout(Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        public SpaceApplicationSummaryBuilder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public SpaceApplicationSummaryBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public SpaceApplicationSummaryBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public SpaceApplicationSummaryBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpaceApplicationSummaryBuilder packageState(String packageState) {
            this.packageState = packageState;
            return this;
        }

        public SpaceApplicationSummaryBuilder packageUpdatedAt(String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
            return this;
        }

        public SpaceApplicationSummaryBuilder production(Boolean production) {
            this.production = production;
            return this;
        }

        public SpaceApplicationSummaryBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public SpaceApplicationSummaryBuilder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public SpaceApplicationSummaryBuilder stagingFailedDescription(String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        public SpaceApplicationSummaryBuilder stagingFailedReason(String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        public SpaceApplicationSummaryBuilder stagingTaskId(String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
            return this;
        }

        public SpaceApplicationSummaryBuilder state(String state) {
            this.state = state;
            return this;
        }

        public SpaceApplicationSummaryBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SpaceApplicationSummaryBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SpaceApplicationSummaryBuilder port(Integer port) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.add(port);
            return this;
        }

        public SpaceApplicationSummaryBuilder ports(Collection<? extends Integer> ports) {
            if (this.ports == null) {
                this.ports = new ArrayList();
            }
            this.ports.addAll(ports);
            return this;
        }

        public SpaceApplicationSummaryBuilder route(Route route) {
            if (this.routes == null) {
                this.routes = new ArrayList();
            }
            this.routes.add(route);
            return this;
        }

        public SpaceApplicationSummaryBuilder routes(Collection<? extends Route> routes) {
            if (this.routes == null) {
                this.routes = new ArrayList();
            }
            this.routes.addAll(routes);
            return this;
        }

        public SpaceApplicationSummaryBuilder runningInstances(Integer runningInstances) {
            this.runningInstances = runningInstances;
            return this;
        }

        public SpaceApplicationSummaryBuilder serviceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public SpaceApplicationSummaryBuilder serviceName(String serviceName) {
            if (this.serviceNames == null) {
                this.serviceNames = new ArrayList();
            }
            this.serviceNames.add(serviceName);
            return this;
        }

        public SpaceApplicationSummaryBuilder serviceNames(Collection<? extends String> serviceNames) {
            if (this.serviceNames == null) {
                this.serviceNames = new ArrayList();
            }
            this.serviceNames.addAll(serviceNames);
            return this;
        }

        public SpaceApplicationSummaryBuilder url(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.add(url);
            return this;
        }

        public SpaceApplicationSummaryBuilder urls(Collection<? extends String> urls) {
            if (this.urls == null) {
                this.urls = new ArrayList();
            }
            this.urls.addAll(urls);
            return this;
        }

        public SpaceApplicationSummary build() {
            List<String> urls;
            List<String> serviceNames;
            List<Route> routes;
            List<Integer> ports;
            Map<Object, Object> environmentJsons;
            Map<Object, Object> dockerCredentialsJsons;
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
                case 0: {
                    dockerCredentialsJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    dockerCredentialsJsons = Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                    break;
                }
                default: {
                    dockerCredentialsJsons = new LinkedHashMap(this.dockerCredentialsJsons$key.size() < 0x40000000 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); ++$i) {
                        dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                    }
                    dockerCredentialsJsons = Collections.unmodifiableMap(dockerCredentialsJsons);
                }
            }
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
                case 0: {
                    environmentJsons = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentJsons = Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                    break;
                }
                default: {
                    environmentJsons = new LinkedHashMap(this.environmentJsons$key.size() < 0x40000000 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentJsons$key.size(); ++$i) {
                        environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                    }
                    environmentJsons = Collections.unmodifiableMap(environmentJsons);
                }
            }
            switch (this.ports == null ? 0 : this.ports.size()) {
                case 0: {
                    ports = Collections.emptyList();
                    break;
                }
                case 1: {
                    ports = Collections.singletonList(this.ports.get(0));
                    break;
                }
                default: {
                    ports = Collections.unmodifiableList(new ArrayList<Integer>(this.ports));
                }
            }
            switch (this.routes == null ? 0 : this.routes.size()) {
                case 0: {
                    routes = Collections.emptyList();
                    break;
                }
                case 1: {
                    routes = Collections.singletonList(this.routes.get(0));
                    break;
                }
                default: {
                    routes = Collections.unmodifiableList(new ArrayList<Route>(this.routes));
                }
            }
            switch (this.serviceNames == null ? 0 : this.serviceNames.size()) {
                case 0: {
                    serviceNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    serviceNames = Collections.singletonList(this.serviceNames.get(0));
                    break;
                }
                default: {
                    serviceNames = Collections.unmodifiableList(new ArrayList<String>(this.serviceNames));
                }
            }
            switch (this.urls == null ? 0 : this.urls.size()) {
                case 0: {
                    urls = Collections.emptyList();
                    break;
                }
                case 1: {
                    urls = Collections.singletonList(this.urls.get(0));
                    break;
                }
                default: {
                    urls = Collections.unmodifiableList(new ArrayList<String>(this.urls));
                }
            }
            return new SpaceApplicationSummary(this.buildpack, this.command, this.console, this.debug, this.detectedBuildpack, this.detectedStartCommand, this.diego, this.diskQuota, dockerCredentialsJsons, this.dockerImage, this.enableSsh, environmentJsons, this.healthCheckTimeout, this.healthCheckType, this.instances, this.memory, this.name, this.packageState, this.packageUpdatedAt, this.production, this.spaceId, this.stackId, this.stagingFailedDescription, this.stagingFailedReason, this.stagingTaskId, this.state, this.version, this.id, ports, routes, this.runningInstances, this.serviceCount, serviceNames, urls);
        }

        public String toString() {
            return "SpaceApplicationSummary.SpaceApplicationSummaryBuilder(buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedBuildpack=" + this.detectedBuildpack + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", packageState=" + this.packageState + ", packageUpdatedAt=" + this.packageUpdatedAt + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", stagingTaskId=" + this.stagingTaskId + ", state=" + this.state + ", version=" + this.version + ", id=" + this.id + ", ports=" + this.ports + ", routes=" + this.routes + ", runningInstances=" + this.runningInstances + ", serviceCount=" + this.serviceCount + ", serviceNames=" + this.serviceNames + ", urls=" + this.urls + ")";
        }
    }
}

