/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.cloudfoundry.client.v2.users.AbstractUserEntity;

public final class UserSpaceRoleEntity
extends AbstractUserEntity {
    private final List<String> spaceRoles;

    UserSpaceRoleEntity(@JsonProperty(value="active") Boolean active, @JsonProperty(value="admin") Boolean admin, @JsonProperty(value="audited_organizations_url") String auditedOrganizationsUrl, @JsonProperty(value="audited_spaces_url") String auditedSpacesUrl, @JsonProperty(value="billing_managed_organizations_url") String billingManagedOrganizationsUrl, @JsonProperty(value="default_space_guid") String defaultSpaceId, @JsonProperty(value="default_space_url") String defaultSpaceUrl, @JsonProperty(value="managed_organizations_url") String managedOrganizationsUrl, @JsonProperty(value="managed_spaces_url") String managedSpacesUrl, @JsonProperty(value="organizations_url") String organizationsUrl, @JsonProperty(value="space_roles") List<String> spaceRoles, @JsonProperty(value="spaces_url") String spacesUrl, @JsonProperty(value="username") String username) {
        super(active, admin, auditedOrganizationsUrl, auditedSpacesUrl, billingManagedOrganizationsUrl, defaultSpaceId, defaultSpaceUrl, managedOrganizationsUrl, managedSpacesUrl, organizationsUrl, spacesUrl, username);
        this.spaceRoles = Optional.ofNullable(spaceRoles).orElse(Collections.emptyList());
    }

    public static UserSpaceRoleEntityBuilder builder() {
        return new UserSpaceRoleEntityBuilder();
    }

    public List<String> getSpaceRoles() {
        return this.spaceRoles;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserSpaceRoleEntity)) {
            return false;
        }
        UserSpaceRoleEntity other = (UserSpaceRoleEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$spaceRoles = this.getSpaceRoles();
        List<String> other$spaceRoles = other.getSpaceRoles();
        return !(this$spaceRoles == null ? other$spaceRoles != null : !((Object)this$spaceRoles).equals(other$spaceRoles));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserSpaceRoleEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $spaceRoles = this.getSpaceRoles();
        result = result * 59 + ($spaceRoles == null ? 43 : ((Object)$spaceRoles).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UserSpaceRoleEntity(super=" + super.toString() + ", spaceRoles=" + this.getSpaceRoles() + ")";
    }

    public static class UserSpaceRoleEntityBuilder {
        private Boolean active;
        private Boolean admin;
        private String auditedOrganizationsUrl;
        private String auditedSpacesUrl;
        private String billingManagedOrganizationsUrl;
        private String defaultSpaceId;
        private String defaultSpaceUrl;
        private String managedOrganizationsUrl;
        private String managedSpacesUrl;
        private String organizationsUrl;
        private ArrayList<String> spaceRoles;
        private String spacesUrl;
        private String username;

        UserSpaceRoleEntityBuilder() {
        }

        public UserSpaceRoleEntityBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserSpaceRoleEntityBuilder admin(Boolean admin) {
            this.admin = admin;
            return this;
        }

        public UserSpaceRoleEntityBuilder auditedOrganizationsUrl(String auditedOrganizationsUrl) {
            this.auditedOrganizationsUrl = auditedOrganizationsUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder auditedSpacesUrl(String auditedSpacesUrl) {
            this.auditedSpacesUrl = auditedSpacesUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder billingManagedOrganizationsUrl(String billingManagedOrganizationsUrl) {
            this.billingManagedOrganizationsUrl = billingManagedOrganizationsUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder defaultSpaceId(String defaultSpaceId) {
            this.defaultSpaceId = defaultSpaceId;
            return this;
        }

        public UserSpaceRoleEntityBuilder defaultSpaceUrl(String defaultSpaceUrl) {
            this.defaultSpaceUrl = defaultSpaceUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder managedOrganizationsUrl(String managedOrganizationsUrl) {
            this.managedOrganizationsUrl = managedOrganizationsUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder managedSpacesUrl(String managedSpacesUrl) {
            this.managedSpacesUrl = managedSpacesUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder organizationsUrl(String organizationsUrl) {
            this.organizationsUrl = organizationsUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder spaceRole(String spaceRole) {
            if (this.spaceRoles == null) {
                this.spaceRoles = new ArrayList();
            }
            this.spaceRoles.add(spaceRole);
            return this;
        }

        public UserSpaceRoleEntityBuilder spaceRoles(Collection<? extends String> spaceRoles) {
            if (this.spaceRoles == null) {
                this.spaceRoles = new ArrayList();
            }
            this.spaceRoles.addAll(spaceRoles);
            return this;
        }

        public UserSpaceRoleEntityBuilder spacesUrl(String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        public UserSpaceRoleEntityBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserSpaceRoleEntity build() {
            List<String> spaceRoles;
            switch (this.spaceRoles == null ? 0 : this.spaceRoles.size()) {
                case 0: {
                    spaceRoles = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceRoles = Collections.singletonList(this.spaceRoles.get(0));
                    break;
                }
                default: {
                    spaceRoles = Collections.unmodifiableList(new ArrayList<String>(this.spaceRoles));
                }
            }
            return new UserSpaceRoleEntity(this.active, this.admin, this.auditedOrganizationsUrl, this.auditedSpacesUrl, this.billingManagedOrganizationsUrl, this.defaultSpaceId, this.defaultSpaceUrl, this.managedOrganizationsUrl, this.managedSpacesUrl, this.organizationsUrl, spaceRoles, this.spacesUrl, this.username);
        }

        public String toString() {
            return "UserSpaceRoleEntity.UserSpaceRoleEntityBuilder(active=" + this.active + ", admin=" + this.admin + ", auditedOrganizationsUrl=" + this.auditedOrganizationsUrl + ", auditedSpacesUrl=" + this.auditedSpacesUrl + ", billingManagedOrganizationsUrl=" + this.billingManagedOrganizationsUrl + ", defaultSpaceId=" + this.defaultSpaceId + ", defaultSpaceUrl=" + this.defaultSpaceUrl + ", managedOrganizationsUrl=" + this.managedOrganizationsUrl + ", managedSpacesUrl=" + this.managedSpacesUrl + ", organizationsUrl=" + this.organizationsUrl + ", spaceRoles=" + this.spaceRoles + ", spacesUrl=" + this.spacesUrl + ", username=" + this.username + ")";
        }
    }
}

