/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreateUserProvidedServiceInstanceRequest
implements Validatable {
    private final Map<String, Object> credentials;
    private final String name;
    private final String routeServiceUrl;
    private final String spaceId;
    private final String syslogDrainUrl;

    CreateUserProvidedServiceInstanceRequest(Map<String, Object> credentials, String name, String routeServiceUrl, String spaceId, String syslogDrainUrl) {
        this.credentials = credentials;
        this.name = name;
        this.routeServiceUrl = routeServiceUrl;
        this.spaceId = spaceId;
        this.syslogDrainUrl = syslogDrainUrl;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    public static CreateUserProvidedServiceInstanceRequestBuilder builder() {
        return new CreateUserProvidedServiceInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateUserProvidedServiceInstanceRequest)) {
            return false;
        }
        CreateUserProvidedServiceInstanceRequest other = (CreateUserProvidedServiceInstanceRequest)o;
        Map<String, Object> this$credentials = this.getCredentials();
        Map<String, Object> other$credentials = other.getCredentials();
        if (this$credentials == null ? other$credentials != null : !((Object)this$credentials).equals(other$credentials)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$routeServiceUrl = this.getRouteServiceUrl();
        String other$routeServiceUrl = other.getRouteServiceUrl();
        if (this$routeServiceUrl == null ? other$routeServiceUrl != null : !this$routeServiceUrl.equals(other$routeServiceUrl)) {
            return false;
        }
        String this$spaceId = this.getSpaceId();
        String other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) {
            return false;
        }
        String this$syslogDrainUrl = this.getSyslogDrainUrl();
        String other$syslogDrainUrl = other.getSyslogDrainUrl();
        return !(this$syslogDrainUrl == null ? other$syslogDrainUrl != null : !this$syslogDrainUrl.equals(other$syslogDrainUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $credentials = this.getCredentials();
        result = result * 59 + ($credentials == null ? 43 : ((Object)$credentials).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $routeServiceUrl = this.getRouteServiceUrl();
        result = result * 59 + ($routeServiceUrl == null ? 43 : $routeServiceUrl.hashCode());
        String $spaceId = this.getSpaceId();
        result = result * 59 + ($spaceId == null ? 43 : $spaceId.hashCode());
        String $syslogDrainUrl = this.getSyslogDrainUrl();
        result = result * 59 + ($syslogDrainUrl == null ? 43 : $syslogDrainUrl.hashCode());
        return result;
    }

    public String toString() {
        return "CreateUserProvidedServiceInstanceRequest(credentials=" + this.getCredentials() + ", name=" + this.getName() + ", routeServiceUrl=" + this.getRouteServiceUrl() + ", spaceId=" + this.getSpaceId() + ", syslogDrainUrl=" + this.getSyslogDrainUrl() + ")";
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="route_service_url")
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    @JsonProperty(value="space_guid")
    public String getSpaceId() {
        return this.spaceId;
    }

    @JsonProperty(value="syslog_drain_url")
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    public static class CreateUserProvidedServiceInstanceRequestBuilder {
        private ArrayList<String> credentials$key;
        private ArrayList<Object> credentials$value;
        private String name;
        private String routeServiceUrl;
        private String spaceId;
        private String syslogDrainUrl;

        CreateUserProvidedServiceInstanceRequestBuilder() {
        }

        public CreateUserProvidedServiceInstanceRequestBuilder credential(String credentialKey, Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        public CreateUserProvidedServiceInstanceRequestBuilder credentials(Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateUserProvidedServiceInstanceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateUserProvidedServiceInstanceRequestBuilder routeServiceUrl(String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        public CreateUserProvidedServiceInstanceRequestBuilder spaceId(String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        public CreateUserProvidedServiceInstanceRequestBuilder syslogDrainUrl(String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public CreateUserProvidedServiceInstanceRequest build() {
            Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
                case 0: {
                    credentials = Collections.emptyMap();
                    break;
                }
                case 1: {
                    credentials = Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                    break;
                }
                default: {
                    credentials = new LinkedHashMap(this.credentials$key.size() < 0x40000000 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.credentials$key.size(); ++$i) {
                        credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                    }
                    credentials = Collections.unmodifiableMap(credentials);
                }
            }
            return new CreateUserProvidedServiceInstanceRequest(credentials, this.name, this.routeServiceUrl, this.spaceId, this.syslogDrainUrl);
        }

        public String toString() {
            return "CreateUserProvidedServiceInstanceRequest.CreateUserProvidedServiceInstanceRequestBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", spaceId=" + this.spaceId + ", syslogDrainUrl=" + this.syslogDrainUrl + ")";
        }
    }
}

