/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;

public final class ListUserProvidedServiceInstanceServiceBindingsRequest
extends PaginatedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final String userProvidedServiceInstanceId;

    ListUserProvidedServiceInstanceServiceBindingsRequest(PaginatedRequest.OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, String userProvidedServiceInstanceId) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.userProvidedServiceInstanceId == null) {
            builder.message("user provided service instance id must be specified");
        }
        return builder.build();
    }

    public static ListUserProvidedServiceInstanceServiceBindingsRequestBuilder builder() {
        return new ListUserProvidedServiceInstanceServiceBindingsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListUserProvidedServiceInstanceServiceBindingsRequest)) {
            return false;
        }
        ListUserProvidedServiceInstanceServiceBindingsRequest other = (ListUserProvidedServiceInstanceServiceBindingsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        String this$userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        String other$userProvidedServiceInstanceId = other.getUserProvidedServiceInstanceId();
        return !(this$userProvidedServiceInstanceId == null ? other$userProvidedServiceInstanceId != null : !this$userProvidedServiceInstanceId.equals(other$userProvidedServiceInstanceId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListUserProvidedServiceInstanceServiceBindingsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        String $userProvidedServiceInstanceId = this.getUserProvidedServiceInstanceId();
        result = result * 59 + ($userProvidedServiceInstanceId == null ? 43 : $userProvidedServiceInstanceId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListUserProvidedServiceInstanceServiceBindingsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", userProvidedServiceInstanceId=" + this.getUserProvidedServiceInstanceId() + ")";
    }

    @InFilterParameter(value="app_guid")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @JsonIgnore
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }

    public static class ListUserProvidedServiceInstanceServiceBindingsRequestBuilder {
        private PaginatedRequest.OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;
        private ArrayList<String> applicationIds;
        private String userProvidedServiceInstanceId;

        ListUserProvidedServiceInstanceServiceBindingsRequestBuilder() {
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder orderDirection(PaginatedRequest.OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder resultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequestBuilder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
            return this;
        }

        public ListUserProvidedServiceInstanceServiceBindingsRequest build() {
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            return new ListUserProvidedServiceInstanceServiceBindingsRequest(this.orderDirection, this.page, this.resultsPerPage, applicationIds, this.userProvidedServiceInstanceId);
        }

        public String toString() {
            return "ListUserProvidedServiceInstanceServiceBindingsRequest.ListUserProvidedServiceInstanceServiceBindingsRequestBuilder(orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ")";
        }
    }
}

