/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v2.PaginatedResponse;
import org.cloudfoundry.client.v2.userprovidedserviceinstances.UserProvidedServiceInstanceResource;

public final class ListUserProvidedServiceInstancesResponse
extends PaginatedResponse<UserProvidedServiceInstanceResource> {
    ListUserProvidedServiceInstancesResponse(@JsonProperty(value="next_url") String nextUrl, @JsonProperty(value="prev_url") String previousUrl, @JsonProperty(value="resources") List<UserProvidedServiceInstanceResource> resources, @JsonProperty(value="total_pages") Integer totalPages, @JsonProperty(value="total_results") Integer totalResults) {
        super(nextUrl, previousUrl, resources, totalPages, totalResults);
    }

    public static ListUserProvidedServiceInstancesResponseBuilder builder() {
        return new ListUserProvidedServiceInstancesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListUserProvidedServiceInstancesResponse)) {
            return false;
        }
        ListUserProvidedServiceInstancesResponse other = (ListUserProvidedServiceInstancesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListUserProvidedServiceInstancesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListUserProvidedServiceInstancesResponse(super=" + super.toString() + ")";
    }

    public static class ListUserProvidedServiceInstancesResponseBuilder {
        private String nextUrl;
        private String previousUrl;
        private ArrayList<UserProvidedServiceInstanceResource> resources;
        private Integer totalPages;
        private Integer totalResults;

        ListUserProvidedServiceInstancesResponseBuilder() {
        }

        public ListUserProvidedServiceInstancesResponseBuilder nextUrl(String nextUrl) {
            this.nextUrl = nextUrl;
            return this;
        }

        public ListUserProvidedServiceInstancesResponseBuilder previousUrl(String previousUrl) {
            this.previousUrl = previousUrl;
            return this;
        }

        public ListUserProvidedServiceInstancesResponseBuilder resource(UserProvidedServiceInstanceResource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListUserProvidedServiceInstancesResponseBuilder resources(Collection<? extends UserProvidedServiceInstanceResource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListUserProvidedServiceInstancesResponseBuilder totalPages(Integer totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public ListUserProvidedServiceInstancesResponseBuilder totalResults(Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ListUserProvidedServiceInstancesResponse build() {
            List<UserProvidedServiceInstanceResource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<UserProvidedServiceInstanceResource>(this.resources));
                }
            }
            return new ListUserProvidedServiceInstancesResponse(this.nextUrl, this.previousUrl, resources, this.totalPages, this.totalResults);
        }

        public String toString() {
            return "ListUserProvidedServiceInstancesResponse.ListUserProvidedServiceInstancesResponseBuilder(nextUrl=" + this.nextUrl + ", previousUrl=" + this.previousUrl + ", resources=" + this.resources + ", totalPages=" + this.totalPages + ", totalResults=" + this.totalResults + ")";
        }
    }
}

