/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.userprovidedserviceinstances;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateUserProvidedServiceInstanceRequest
implements Validatable {
    private final Map<String, Object> credentials;
    private final String name;
    private final String routeServiceUrl;
    private final String syslogDrainUrl;
    private final String userProvidedServiceInstanceId;

    UpdateUserProvidedServiceInstanceRequest(Map<String, Object> credentials, String name, String routeServiceUrl, String syslogDrainUrl, String userProvidedServiceInstanceId) {
        this.credentials = credentials;
        this.name = name;
        this.routeServiceUrl = routeServiceUrl;
        this.syslogDrainUrl = syslogDrainUrl;
        this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.userProvidedServiceInstanceId == null) {
            builder.message("user provided service instance id must be specified");
        }
        return builder.build();
    }

    public static UpdateUserProvidedServiceInstanceRequestBuilder builder() {
        return new UpdateUserProvidedServiceInstanceRequestBuilder();
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="route_service_url")
    public String getRouteServiceUrl() {
        return this.routeServiceUrl;
    }

    @JsonProperty(value="syslog_drain_url")
    public String getSyslogDrainUrl() {
        return this.syslogDrainUrl;
    }

    @JsonIgnore
    public String getUserProvidedServiceInstanceId() {
        return this.userProvidedServiceInstanceId;
    }

    public static class UpdateUserProvidedServiceInstanceRequestBuilder {
        private ArrayList<String> credentials$key;
        private ArrayList<Object> credentials$value;
        private String name;
        private String routeServiceUrl;
        private String syslogDrainUrl;
        private String userProvidedServiceInstanceId;

        UpdateUserProvidedServiceInstanceRequestBuilder() {
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder credential(String credentialKey, Object credentialValue) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            this.credentials$key.add(credentialKey);
            this.credentials$value.add(credentialValue);
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder credentials(Map<? extends String, ? extends Object> credentials) {
            if (this.credentials$key == null) {
                this.credentials$key = new ArrayList();
                this.credentials$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : credentials.entrySet()) {
                this.credentials$key.add($lombokEntry.getKey());
                this.credentials$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder routeServiceUrl(String routeServiceUrl) {
            this.routeServiceUrl = routeServiceUrl;
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder syslogDrainUrl(String syslogDrainUrl) {
            this.syslogDrainUrl = syslogDrainUrl;
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequestBuilder userProvidedServiceInstanceId(String userProvidedServiceInstanceId) {
            this.userProvidedServiceInstanceId = userProvidedServiceInstanceId;
            return this;
        }

        public UpdateUserProvidedServiceInstanceRequest build() {
            Map<String, Object> credentials;
            switch (this.credentials$key == null ? 0 : this.credentials$key.size()) {
                case 0: {
                    credentials = Collections.emptyMap();
                    break;
                }
                case 1: {
                    credentials = Collections.singletonMap(this.credentials$key.get(0), this.credentials$value.get(0));
                    break;
                }
                default: {
                    credentials = new LinkedHashMap(this.credentials$key.size() < 0x40000000 ? 1 + this.credentials$key.size() + (this.credentials$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.credentials$key.size(); ++$i) {
                        credentials.put(this.credentials$key.get($i), this.credentials$value.get($i));
                    }
                    credentials = Collections.unmodifiableMap(credentials);
                }
            }
            return new UpdateUserProvidedServiceInstanceRequest(credentials, this.name, this.routeServiceUrl, this.syslogDrainUrl, this.userProvidedServiceInstanceId);
        }

        public String toString() {
            return "UpdateUserProvidedServiceInstanceRequest.UpdateUserProvidedServiceInstanceRequestBuilder(credentials$key=" + this.credentials$key + ", credentials$value=" + this.credentials$value + ", name=" + this.name + ", routeServiceUrl=" + this.routeServiceUrl + ", syslogDrainUrl=" + this.syslogDrainUrl + ", userProvidedServiceInstanceId=" + this.userProvidedServiceInstanceId + ")";
        }
    }
}

