/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.ValidationResult;

public abstract class PaginatedRequest {
    private final Integer page;
    private final Integer perPage;

    protected PaginatedRequest(Integer page, Integer perPage) {
        this.page = page;
        this.perPage = perPage;
    }

    protected final ValidationResult.ValidationResultBuilder isPaginatedRequestValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.page != null && this.page < 1) {
            builder.message("page must be greater than or equal to 1");
        }
        if (this.perPage != null && (this.perPage < 1 || this.perPage > 5000)) {
            builder.message("perPage must be between 1 and 5000 inclusive");
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginatedRequest)) {
            return false;
        }
        PaginatedRequest other = (PaginatedRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$page = this.getPage();
        Integer other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Integer this$perPage = this.getPerPage();
        Integer other$perPage = other.getPerPage();
        return !(this$perPage == null ? other$perPage != null : !((Object)this$perPage).equals(other$perPage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginatedRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Integer $perPage = this.getPerPage();
        result = result * 59 + ($perPage == null ? 43 : ((Object)$perPage).hashCode());
        return result;
    }

    public String toString() {
        return "PaginatedRequest(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ")";
    }

    @QueryParameter(value="page")
    public Integer getPage() {
        return this.page;
    }

    @QueryParameter(value="per_page")
    public Integer getPerPage() {
        return this.perPage;
    }
}

