/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.cloudfoundry.client.v3.Link;

public abstract class PaginatedResponse<T> {
    private final Pagination pagination;
    private final List<T> resources;

    protected PaginatedResponse(@JsonProperty(value="pagination") Pagination pagination, @JsonProperty(value="resources") List<T> resources) {
        this.pagination = pagination;
        this.resources = resources;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public List<T> getResources() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginatedResponse)) {
            return false;
        }
        PaginatedResponse other = (PaginatedResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination)) {
            return false;
        }
        List<T> this$resources = this.getResources();
        List<T> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaginatedResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        List<T> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    public String toString() {
        return "PaginatedResponse(pagination=" + this.getPagination() + ", resources=" + this.getResources() + ")";
    }

    public static final class Pagination {
        private final Link first;
        private final Link last;
        private final Link next;
        private final Link previous;
        private final Integer totalResults;

        Pagination(@JsonProperty(value="first") Link first, @JsonProperty(value="last") Link last, @JsonProperty(value="next") Link next, @JsonProperty(value="previous") Link previous, @JsonProperty(value="total_results") Integer totalResults) {
            this.first = first;
            this.last = last;
            this.next = next;
            this.previous = previous;
            this.totalResults = totalResults;
        }

        public static PaginationBuilder builder() {
            return new PaginationBuilder();
        }

        public Link getFirst() {
            return this.first;
        }

        public Link getLast() {
            return this.last;
        }

        public Link getNext() {
            return this.next;
        }

        public Link getPrevious() {
            return this.previous;
        }

        public Integer getTotalResults() {
            return this.totalResults;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pagination)) {
                return false;
            }
            Pagination other = (Pagination)o;
            Link this$first = this.getFirst();
            Link other$first = other.getFirst();
            if (this$first == null ? other$first != null : !((Object)this$first).equals(other$first)) {
                return false;
            }
            Link this$last = this.getLast();
            Link other$last = other.getLast();
            if (this$last == null ? other$last != null : !((Object)this$last).equals(other$last)) {
                return false;
            }
            Link this$next = this.getNext();
            Link other$next = other.getNext();
            if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
                return false;
            }
            Link this$previous = this.getPrevious();
            Link other$previous = other.getPrevious();
            if (this$previous == null ? other$previous != null : !((Object)this$previous).equals(other$previous)) {
                return false;
            }
            Integer this$totalResults = this.getTotalResults();
            Integer other$totalResults = other.getTotalResults();
            return !(this$totalResults == null ? other$totalResults != null : !((Object)this$totalResults).equals(other$totalResults));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : ((Object)$first).hashCode());
            Link $last = this.getLast();
            result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
            Link $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
            Link $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : ((Object)$previous).hashCode());
            Integer $totalResults = this.getTotalResults();
            result = result * 59 + ($totalResults == null ? 43 : ((Object)$totalResults).hashCode());
            return result;
        }

        public String toString() {
            return "PaginatedResponse.Pagination(first=" + this.getFirst() + ", last=" + this.getLast() + ", next=" + this.getNext() + ", previous=" + this.getPrevious() + ", totalResults=" + this.getTotalResults() + ")";
        }

        public static class PaginationBuilder {
            private Link first;
            private Link last;
            private Link next;
            private Link previous;
            private Integer totalResults;

            PaginationBuilder() {
            }

            public PaginationBuilder first(Link first) {
                this.first = first;
                return this;
            }

            public PaginationBuilder last(Link last) {
                this.last = last;
                return this;
            }

            public PaginationBuilder next(Link next) {
                this.next = next;
                return this;
            }

            public PaginationBuilder previous(Link previous) {
                this.previous = previous;
                return this;
            }

            public PaginationBuilder totalResults(Integer totalResults) {
                this.totalResults = totalResults;
                return this;
            }

            public Pagination build() {
                return new Pagination(this.first, this.last, this.next, this.previous, this.totalResults);
            }

            public String toString() {
                return "PaginatedResponse.Pagination.PaginationBuilder(first=" + this.first + ", last=" + this.last + ", next=" + this.next + ", previous=" + this.previous + ", totalResults=" + this.totalResults + ")";
            }
        }
    }
}

