/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class AssignApplicationDropletRequest
implements Validatable {
    private final String applicationId;
    private final String dropletId;

    AssignApplicationDropletRequest(String applicationId, String dropletId) {
        this.applicationId = applicationId;
        this.dropletId = dropletId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.dropletId == null) {
            builder.message("droplet id must be specified");
        }
        return builder.build();
    }

    public static AssignApplicationDropletRequestBuilder builder() {
        return new AssignApplicationDropletRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssignApplicationDropletRequest)) {
            return false;
        }
        AssignApplicationDropletRequest other = (AssignApplicationDropletRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$dropletId = this.getDropletId();
        String other$dropletId = other.getDropletId();
        return !(this$dropletId == null ? other$dropletId != null : !this$dropletId.equals(other$dropletId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $dropletId = this.getDropletId();
        result = result * 59 + ($dropletId == null ? 43 : $dropletId.hashCode());
        return result;
    }

    public String toString() {
        return "AssignApplicationDropletRequest(applicationId=" + this.getApplicationId() + ", dropletId=" + this.getDropletId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="droplet_guid")
    public String getDropletId() {
        return this.dropletId;
    }

    public static class AssignApplicationDropletRequestBuilder {
        private String applicationId;
        private String dropletId;

        AssignApplicationDropletRequestBuilder() {
        }

        public AssignApplicationDropletRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public AssignApplicationDropletRequestBuilder dropletId(String dropletId) {
            this.dropletId = dropletId;
            return this;
        }

        public AssignApplicationDropletRequest build() {
            return new AssignApplicationDropletRequest(this.applicationId, this.dropletId);
        }

        public String toString() {
            return "AssignApplicationDropletRequest.AssignApplicationDropletRequestBuilder(applicationId=" + this.applicationId + ", dropletId=" + this.dropletId + ")";
        }
    }
}

