/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Relationship;

public final class CreateApplicationRequest
implements Validatable {
    private final Map<String, String> environmentVariables;
    private final Lifecycle lifecycle;
    private final String name;
    private final Map<String, Relationship> relationships;

    CreateApplicationRequest(Map<String, String> environmentVariables, Lifecycle lifecycle, String name, Map<String, Relationship> relationships) {
        this.environmentVariables = environmentVariables;
        this.lifecycle = lifecycle;
        this.name = name;
        this.relationships = relationships;
    }

    @Override
    public ValidationResult isValid() {
        Relationship spaceRelationship;
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if ((spaceRelationship = this.relationships.get("space")) == null) {
            builder.message("space relationship must be specified");
        } else {
            builder.messages(spaceRelationship.isValid().getMessages());
        }
        return builder.build();
    }

    public static CreateApplicationRequestBuilder builder() {
        return new CreateApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)o;
        Map<String, String> this$environmentVariables = this.getEnvironmentVariables();
        Map<String, String> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, Relationship> this$relationships = this.getRelationships();
        Map<String, Relationship> other$relationships = other.getRelationships();
        return !(this$relationships == null ? other$relationships != null : !((Object)this$relationships).equals(other$relationships));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, Relationship> $relationships = this.getRelationships();
        result = result * 59 + ($relationships == null ? 43 : ((Object)$relationships).hashCode());
        return result;
    }

    public String toString() {
        return "CreateApplicationRequest(environmentVariables=" + this.getEnvironmentVariables() + ", lifecycle=" + this.getLifecycle() + ", name=" + this.getName() + ", relationships=" + this.getRelationships() + ")";
    }

    @JsonProperty(value="environment_variables")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="relationships")
    public Map<String, Relationship> getRelationships() {
        return this.relationships;
    }

    public static class CreateApplicationRequestBuilder {
        private ArrayList<String> environmentVariables$key;
        private ArrayList<String> environmentVariables$value;
        private Lifecycle lifecycle;
        private String name;
        private ArrayList<String> relationships$key;
        private ArrayList<Relationship> relationships$value;

        CreateApplicationRequestBuilder() {
        }

        public CreateApplicationRequestBuilder environmentVariable(String environmentVariableKey, String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public CreateApplicationRequestBuilder environmentVariables(Map<? extends String, ? extends String> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateApplicationRequestBuilder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public CreateApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateApplicationRequestBuilder relationship(String relationshipKey, Relationship relationshipValue) {
            if (this.relationships$key == null) {
                this.relationships$key = new ArrayList();
                this.relationships$value = new ArrayList();
            }
            this.relationships$key.add(relationshipKey);
            this.relationships$value.add(relationshipValue);
            return this;
        }

        public CreateApplicationRequestBuilder relationships(Map<? extends String, ? extends Relationship> relationships) {
            if (this.relationships$key == null) {
                this.relationships$key = new ArrayList();
                this.relationships$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Relationship> $lombokEntry : relationships.entrySet()) {
                this.relationships$key.add($lombokEntry.getKey());
                this.relationships$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreateApplicationRequest build() {
            Map<String, Relationship> relationships;
            Map<String, String> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            switch (this.relationships$key == null ? 0 : this.relationships$key.size()) {
                case 0: {
                    relationships = Collections.emptyMap();
                    break;
                }
                case 1: {
                    relationships = Collections.singletonMap(this.relationships$key.get(0), this.relationships$value.get(0));
                    break;
                }
                default: {
                    relationships = new LinkedHashMap(this.relationships$key.size() < 0x40000000 ? 1 + this.relationships$key.size() + (this.relationships$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.relationships$key.size(); ++$i) {
                        relationships.put(this.relationships$key.get($i), this.relationships$value.get($i));
                    }
                    relationships = Collections.unmodifiableMap(relationships);
                }
            }
            return new CreateApplicationRequest(environmentVariables, this.lifecycle, this.name, relationships);
        }

        public String toString() {
            return "CreateApplicationRequest.CreateApplicationRequestBuilder(environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", lifecycle=" + this.lifecycle + ", name=" + this.name + ", relationships$key=" + this.relationships$key + ", relationships$value=" + this.relationships$value + ")";
        }
    }
}

