/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.PaginatedRequest;

public final class GetApplicationProcessDetailedStatisticsRequest
extends PaginatedRequest
implements Validatable {
    private final String applicationId;
    private final String type;

    GetApplicationProcessDetailedStatisticsRequest(Integer page, Integer perPage, String applicationId, String type) {
        super(page, perPage);
        this.applicationId = applicationId;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("process type must be specified");
        }
        return builder.build();
    }

    public static GetApplicationProcessDetailedStatisticsRequestBuilder builder() {
        return new GetApplicationProcessDetailedStatisticsRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetApplicationProcessDetailedStatisticsRequest(applicationId=" + this.getApplicationId() + ", type=" + this.getType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetApplicationProcessDetailedStatisticsRequest)) {
            return false;
        }
        GetApplicationProcessDetailedStatisticsRequest other = (GetApplicationProcessDetailedStatisticsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetApplicationProcessDetailedStatisticsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public static class GetApplicationProcessDetailedStatisticsRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String applicationId;
        private String type;

        GetApplicationProcessDetailedStatisticsRequestBuilder() {
        }

        public GetApplicationProcessDetailedStatisticsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public GetApplicationProcessDetailedStatisticsRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public GetApplicationProcessDetailedStatisticsRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetApplicationProcessDetailedStatisticsRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public GetApplicationProcessDetailedStatisticsRequest build() {
            return new GetApplicationProcessDetailedStatisticsRequest(this.page, this.perPage, this.applicationId, this.type);
        }

        public String toString() {
            return "GetApplicationProcessDetailedStatisticsRequest.GetApplicationProcessDetailedStatisticsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", applicationId=" + this.applicationId + ", type=" + this.type + ")";
        }
    }
}

