/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v3.PaginatedResponse;
import org.cloudfoundry.client.v3.processes.AbstractProcessDetailedStatistics;
import org.cloudfoundry.client.v3.processes.ProcessUsage;

public final class GetApplicationProcessDetailedStatisticsResponse
extends PaginatedResponse<Resource> {
    GetApplicationProcessDetailedStatisticsResponse(@JsonProperty(value="pagination") PaginatedResponse.Pagination pagination, @JsonProperty(value="resources") List<Resource> resources) {
        super(pagination, resources);
    }

    public static GetApplicationProcessDetailedStatisticsResponseBuilder builder() {
        return new GetApplicationProcessDetailedStatisticsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetApplicationProcessDetailedStatisticsResponse)) {
            return false;
        }
        GetApplicationProcessDetailedStatisticsResponse other = (GetApplicationProcessDetailedStatisticsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetApplicationProcessDetailedStatisticsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "GetApplicationProcessDetailedStatisticsResponse(super=" + super.toString() + ")";
    }

    public static class GetApplicationProcessDetailedStatisticsResponseBuilder {
        private PaginatedResponse.Pagination pagination;
        private ArrayList<Resource> resources;

        GetApplicationProcessDetailedStatisticsResponseBuilder() {
        }

        public GetApplicationProcessDetailedStatisticsResponseBuilder pagination(PaginatedResponse.Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public GetApplicationProcessDetailedStatisticsResponseBuilder resource(Resource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public GetApplicationProcessDetailedStatisticsResponseBuilder resources(Collection<? extends Resource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public GetApplicationProcessDetailedStatisticsResponse build() {
            List<Resource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<Resource>(this.resources));
                }
            }
            return new GetApplicationProcessDetailedStatisticsResponse(this.pagination, resources);
        }

        public String toString() {
            return "GetApplicationProcessDetailedStatisticsResponse.GetApplicationProcessDetailedStatisticsResponseBuilder(pagination=" + this.pagination + ", resources=" + this.resources + ")";
        }
    }

    public static final class Resource
    extends AbstractProcessDetailedStatistics {
        Resource(@JsonProperty(value="disk_quota") Long diskQuota, @JsonProperty(value="fds_quota") Integer fdsQuota, @JsonProperty(value="host") String host, @JsonProperty(value="index") Integer index, @JsonProperty(value="mem_quota") Long memoryQuota, @JsonProperty(value="port") Integer port, @JsonProperty(value="state") String state, @JsonProperty(value="type") String type, @JsonProperty(value="uptime") Long uptime, @JsonProperty(value="usage") ProcessUsage usage) {
            super(diskQuota, fdsQuota, host, index, memoryQuota, port, state, type, uptime, usage);
        }

        public static ResourceBuilder builder() {
            return new ResourceBuilder();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "GetApplicationProcessDetailedStatisticsResponse.Resource(super=" + super.toString() + ")";
        }

        public static class ResourceBuilder {
            private Long diskQuota;
            private Integer fdsQuota;
            private String host;
            private Integer index;
            private Long memoryQuota;
            private Integer port;
            private String state;
            private String type;
            private Long uptime;
            private ProcessUsage usage;

            ResourceBuilder() {
            }

            public ResourceBuilder diskQuota(Long diskQuota) {
                this.diskQuota = diskQuota;
                return this;
            }

            public ResourceBuilder fdsQuota(Integer fdsQuota) {
                this.fdsQuota = fdsQuota;
                return this;
            }

            public ResourceBuilder host(String host) {
                this.host = host;
                return this;
            }

            public ResourceBuilder index(Integer index) {
                this.index = index;
                return this;
            }

            public ResourceBuilder memoryQuota(Long memoryQuota) {
                this.memoryQuota = memoryQuota;
                return this;
            }

            public ResourceBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            public ResourceBuilder state(String state) {
                this.state = state;
                return this;
            }

            public ResourceBuilder type(String type) {
                this.type = type;
                return this;
            }

            public ResourceBuilder uptime(Long uptime) {
                this.uptime = uptime;
                return this;
            }

            public ResourceBuilder usage(ProcessUsage usage) {
                this.usage = usage;
                return this;
            }

            public Resource build() {
                return new Resource(this.diskQuota, this.fdsQuota, this.host, this.index, this.memoryQuota, this.port, this.state, this.type, this.uptime, this.usage);
            }

            public String toString() {
                return "GetApplicationProcessDetailedStatisticsResponse.Resource.ResourceBuilder(diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", index=" + this.index + ", memoryQuota=" + this.memoryQuota + ", port=" + this.port + ", state=" + this.state + ", type=" + this.type + ", uptime=" + this.uptime + ", usage=" + this.usage + ")";
            }
        }
    }
}

