/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetApplicationProcessRequest
implements Validatable {
    private final String applicationId;
    private final String type;

    GetApplicationProcessRequest(String applicationId, String type) {
        this.applicationId = applicationId;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    public static GetApplicationProcessRequestBuilder builder() {
        return new GetApplicationProcessRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetApplicationProcessRequest)) {
            return false;
        }
        GetApplicationProcessRequest other = (GetApplicationProcessRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "GetApplicationProcessRequest(applicationId=" + this.getApplicationId() + ", type=" + this.getType() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public static class GetApplicationProcessRequestBuilder {
        private String applicationId;
        private String type;

        GetApplicationProcessRequestBuilder() {
        }

        public GetApplicationProcessRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetApplicationProcessRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public GetApplicationProcessRequest build() {
            return new GetApplicationProcessRequest(this.applicationId, this.type);
        }

        public String toString() {
            return "GetApplicationProcessRequest.GetApplicationProcessRequestBuilder(applicationId=" + this.applicationId + ", type=" + this.type + ")";
        }
    }
}

