/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.v3.processes.AbstractProcessDetailedStatistics;
import org.cloudfoundry.client.v3.processes.ProcessUsage;

public final class GetApplicationStatisticsResponse {
    private final List<Statistics> processes;

    GetApplicationStatisticsResponse(@JsonProperty(value="processes") List<Statistics> processes) {
        this.processes = processes;
    }

    public static GetApplicationStatisticsResponseBuilder builder() {
        return new GetApplicationStatisticsResponseBuilder();
    }

    public List<Statistics> getProcesses() {
        return this.processes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetApplicationStatisticsResponse)) {
            return false;
        }
        GetApplicationStatisticsResponse other = (GetApplicationStatisticsResponse)o;
        List<Statistics> this$processes = this.getProcesses();
        List<Statistics> other$processes = other.getProcesses();
        return !(this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Statistics> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        return result;
    }

    public String toString() {
        return "GetApplicationStatisticsResponse(processes=" + this.getProcesses() + ")";
    }

    public static class GetApplicationStatisticsResponseBuilder {
        private ArrayList<Statistics> processes;

        GetApplicationStatisticsResponseBuilder() {
        }

        public GetApplicationStatisticsResponseBuilder process(Statistics process) {
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.add(process);
            return this;
        }

        public GetApplicationStatisticsResponseBuilder processes(Collection<? extends Statistics> processes) {
            if (this.processes == null) {
                this.processes = new ArrayList();
            }
            this.processes.addAll(processes);
            return this;
        }

        public GetApplicationStatisticsResponse build() {
            List<Statistics> processes;
            switch (this.processes == null ? 0 : this.processes.size()) {
                case 0: {
                    processes = Collections.emptyList();
                    break;
                }
                case 1: {
                    processes = Collections.singletonList(this.processes.get(0));
                    break;
                }
                default: {
                    processes = Collections.unmodifiableList(new ArrayList<Statistics>(this.processes));
                }
            }
            return new GetApplicationStatisticsResponse(processes);
        }

        public String toString() {
            return "GetApplicationStatisticsResponse.GetApplicationStatisticsResponseBuilder(processes=" + this.processes + ")";
        }
    }

    public static final class Statistics
    extends AbstractProcessDetailedStatistics {
        Statistics(@JsonProperty(value="disk_quota") Long diskQuota, @JsonProperty(value="fds_quota") Integer fdsQuota, @JsonProperty(value="host") String host, @JsonProperty(value="index") Integer index, @JsonProperty(value="mem_quota") Long memoryQuota, @JsonProperty(value="port") Integer port, @JsonProperty(value="state") String state, @JsonProperty(value="type") String type, @JsonProperty(value="uptime") Long uptime, @JsonProperty(value="usage") ProcessUsage usage) {
            super(diskQuota, fdsQuota, host, index, memoryQuota, port, state, type, uptime, usage);
        }

        public static StatisticsBuilder builder() {
            return new StatisticsBuilder();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Statistics)) {
                return false;
            }
            Statistics other = (Statistics)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Statistics;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "GetApplicationStatisticsResponse.Statistics(super=" + super.toString() + ")";
        }

        public static class StatisticsBuilder {
            private Long diskQuota;
            private Integer fdsQuota;
            private String host;
            private Integer index;
            private Long memoryQuota;
            private Integer port;
            private String state;
            private String type;
            private Long uptime;
            private ProcessUsage usage;

            StatisticsBuilder() {
            }

            public StatisticsBuilder diskQuota(Long diskQuota) {
                this.diskQuota = diskQuota;
                return this;
            }

            public StatisticsBuilder fdsQuota(Integer fdsQuota) {
                this.fdsQuota = fdsQuota;
                return this;
            }

            public StatisticsBuilder host(String host) {
                this.host = host;
                return this;
            }

            public StatisticsBuilder index(Integer index) {
                this.index = index;
                return this;
            }

            public StatisticsBuilder memoryQuota(Long memoryQuota) {
                this.memoryQuota = memoryQuota;
                return this;
            }

            public StatisticsBuilder port(Integer port) {
                this.port = port;
                return this;
            }

            public StatisticsBuilder state(String state) {
                this.state = state;
                return this;
            }

            public StatisticsBuilder type(String type) {
                this.type = type;
                return this;
            }

            public StatisticsBuilder uptime(Long uptime) {
                this.uptime = uptime;
                return this;
            }

            public StatisticsBuilder usage(ProcessUsage usage) {
                this.usage = usage;
                return this;
            }

            public Statistics build() {
                return new Statistics(this.diskQuota, this.fdsQuota, this.host, this.index, this.memoryQuota, this.port, this.state, this.type, this.uptime, this.usage);
            }

            public String toString() {
                return "GetApplicationStatisticsResponse.Statistics.StatisticsBuilder(diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", index=" + this.index + ", memoryQuota=" + this.memoryQuota + ", port=" + this.port + ", state=" + this.state + ", type=" + this.type + ", uptime=" + this.uptime + ", usage=" + this.usage + ")";
            }
        }
    }
}

