/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetApplicationTaskRequest
implements Validatable {
    private final String applicationId;
    private final String taskId;

    GetApplicationTaskRequest(String applicationId, String taskId) {
        this.applicationId = applicationId;
        this.taskId = taskId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.taskId == null) {
            builder.message("task id must be specified");
        }
        return builder.build();
    }

    public static GetApplicationTaskRequestBuilder builder() {
        return new GetApplicationTaskRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetApplicationTaskRequest)) {
            return false;
        }
        GetApplicationTaskRequest other = (GetApplicationTaskRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        return result;
    }

    public String toString() {
        return "GetApplicationTaskRequest(applicationId=" + this.getApplicationId() + ", taskId=" + this.getTaskId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonIgnore
    public String getTaskId() {
        return this.taskId;
    }

    public static class GetApplicationTaskRequestBuilder {
        private String applicationId;
        private String taskId;

        GetApplicationTaskRequestBuilder() {
        }

        public GetApplicationTaskRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetApplicationTaskRequestBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public GetApplicationTaskRequest build() {
            return new GetApplicationTaskRequest(this.applicationId, this.taskId);
        }

        public String toString() {
            return "GetApplicationTaskRequest.GetApplicationTaskRequestBuilder(applicationId=" + this.applicationId + ", taskId=" + this.taskId + ")";
        }
    }
}

