/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;

public final class ListApplicationDropletsRequest
extends PaginatedAndSortedRequest
implements Validatable {
    private final String applicationId;
    private final List<String> states;

    ListApplicationDropletsRequest(Integer page, Integer perPage, String orderBy, String applicationId, List<String> states) {
        super(page, perPage, orderBy);
        this.applicationId = applicationId;
        this.states = states;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = this.isPaginatedAndSortedRequestValid();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static ListApplicationDropletsRequestBuilder builder() {
        return new ListApplicationDropletsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationDropletsRequest)) {
            return false;
        }
        ListApplicationDropletsRequest other = (ListApplicationDropletsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        List<String> this$states = this.getStates();
        List<String> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationDropletsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        List<String> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationDropletsRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", states=" + this.getStates() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @FilterParameter(value="state")
    public List<String> getStates() {
        return this.states;
    }

    public static class ListApplicationDropletsRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String orderBy;
        private String applicationId;
        private ArrayList<String> states;

        ListApplicationDropletsRequestBuilder() {
        }

        public ListApplicationDropletsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationDropletsRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationDropletsRequestBuilder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public ListApplicationDropletsRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ListApplicationDropletsRequestBuilder state(String state) {
            if (this.states == null) {
                this.states = new ArrayList();
            }
            this.states.add(state);
            return this;
        }

        public ListApplicationDropletsRequestBuilder states(Collection<? extends String> states) {
            if (this.states == null) {
                this.states = new ArrayList();
            }
            this.states.addAll(states);
            return this;
        }

        public ListApplicationDropletsRequest build() {
            List<String> states;
            switch (this.states == null ? 0 : this.states.size()) {
                case 0: {
                    states = Collections.emptyList();
                    break;
                }
                case 1: {
                    states = Collections.singletonList(this.states.get(0));
                    break;
                }
                default: {
                    states = Collections.unmodifiableList(new ArrayList<String>(this.states));
                }
            }
            return new ListApplicationDropletsRequest(this.page, this.perPage, this.orderBy, this.applicationId, states);
        }

        public String toString() {
            return "ListApplicationDropletsRequest.ListApplicationDropletsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", applicationId=" + this.applicationId + ", states=" + this.states + ")";
        }
    }
}

