/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.PaginatedResponse;
import org.cloudfoundry.client.v3.droplets.Droplet;

public final class ListApplicationDropletsResponse
extends PaginatedResponse<Resource> {
    ListApplicationDropletsResponse(@JsonProperty(value="pagination") PaginatedResponse.Pagination pagination, @JsonProperty(value="resources") List<Resource> resources) {
        super(pagination, resources);
    }

    public static ListApplicationDropletsResponseBuilder builder() {
        return new ListApplicationDropletsResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationDropletsResponse)) {
            return false;
        }
        ListApplicationDropletsResponse other = (ListApplicationDropletsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationDropletsResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationDropletsResponse(super=" + super.toString() + ")";
    }

    public static class ListApplicationDropletsResponseBuilder {
        private PaginatedResponse.Pagination pagination;
        private ArrayList<Resource> resources;

        ListApplicationDropletsResponseBuilder() {
        }

        public ListApplicationDropletsResponseBuilder pagination(PaginatedResponse.Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public ListApplicationDropletsResponseBuilder resource(Resource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListApplicationDropletsResponseBuilder resources(Collection<? extends Resource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListApplicationDropletsResponse build() {
            List<Resource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<Resource>(this.resources));
                }
            }
            return new ListApplicationDropletsResponse(this.pagination, resources);
        }

        public String toString() {
            return "ListApplicationDropletsResponse.ListApplicationDropletsResponseBuilder(pagination=" + this.pagination + ", resources=" + this.resources + ")";
        }
    }

    public static final class Resource
    extends Droplet {
        Resource(@JsonProperty(value="created_at") String createdAt, @JsonProperty(value="disk_limit") Integer diskLimit, @JsonProperty(value="environment_variables") Map<String, Object> environmentVariables, @JsonProperty(value="error") String error, @JsonProperty(value="lifecycle") Lifecycle lifecycle, @JsonProperty(value="guid") String id, @JsonProperty(value="links") Map<String, Link> links, @JsonProperty(value="memory_limit") Integer memoryLimit, @JsonProperty(value="result") Map<String, Object> results, @JsonProperty(value="state") String state, @JsonProperty(value="updated_at") String updatedAt) {
            super(createdAt, diskLimit, environmentVariables, error, lifecycle, id, links, memoryLimit, results, state, updatedAt);
        }

        public static ResourceBuilder builder() {
            return new ResourceBuilder();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "ListApplicationDropletsResponse.Resource(super=" + super.toString() + ")";
        }

        public static class ResourceBuilder {
            private String createdAt;
            private Integer diskLimit;
            private ArrayList<String> environmentVariables$key;
            private ArrayList<Object> environmentVariables$value;
            private String error;
            private Lifecycle lifecycle;
            private String id;
            private ArrayList<String> links$key;
            private ArrayList<Link> links$value;
            private Integer memoryLimit;
            private ArrayList<String> results$key;
            private ArrayList<Object> results$value;
            private String state;
            private String updatedAt;

            ResourceBuilder() {
            }

            public ResourceBuilder createdAt(String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public ResourceBuilder diskLimit(Integer diskLimit) {
                this.diskLimit = diskLimit;
                return this;
            }

            public ResourceBuilder environmentVariable(String environmentVariableKey, Object environmentVariableValue) {
                if (this.environmentVariables$key == null) {
                    this.environmentVariables$key = new ArrayList();
                    this.environmentVariables$value = new ArrayList();
                }
                this.environmentVariables$key.add(environmentVariableKey);
                this.environmentVariables$value.add(environmentVariableValue);
                return this;
            }

            public ResourceBuilder environmentVariables(Map<? extends String, ? extends Object> environmentVariables) {
                if (this.environmentVariables$key == null) {
                    this.environmentVariables$key = new ArrayList();
                    this.environmentVariables$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentVariables.entrySet()) {
                    this.environmentVariables$key.add($lombokEntry.getKey());
                    this.environmentVariables$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ResourceBuilder error(String error) {
                this.error = error;
                return this;
            }

            public ResourceBuilder lifecycle(Lifecycle lifecycle) {
                this.lifecycle = lifecycle;
                return this;
            }

            public ResourceBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ResourceBuilder link(String linkKey, Link linkValue) {
                if (this.links$key == null) {
                    this.links$key = new ArrayList();
                    this.links$value = new ArrayList();
                }
                this.links$key.add(linkKey);
                this.links$value.add(linkValue);
                return this;
            }

            public ResourceBuilder links(Map<? extends String, ? extends Link> links) {
                if (this.links$key == null) {
                    this.links$key = new ArrayList();
                    this.links$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Link> $lombokEntry : links.entrySet()) {
                    this.links$key.add($lombokEntry.getKey());
                    this.links$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ResourceBuilder memoryLimit(Integer memoryLimit) {
                this.memoryLimit = memoryLimit;
                return this;
            }

            public ResourceBuilder result(String resultKey, Object resultValue) {
                if (this.results$key == null) {
                    this.results$key = new ArrayList();
                    this.results$value = new ArrayList();
                }
                this.results$key.add(resultKey);
                this.results$value.add(resultValue);
                return this;
            }

            public ResourceBuilder results(Map<? extends String, ? extends Object> results) {
                if (this.results$key == null) {
                    this.results$key = new ArrayList();
                    this.results$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : results.entrySet()) {
                    this.results$key.add($lombokEntry.getKey());
                    this.results$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ResourceBuilder state(String state) {
                this.state = state;
                return this;
            }

            public ResourceBuilder updatedAt(String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Resource build() {
                Map<String, Object> results;
                Map<Object, Object> links;
                Map<Object, Object> environmentVariables;
                switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                    case 0: {
                        environmentVariables = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                        break;
                    }
                    default: {
                        environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                            environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                        }
                        environmentVariables = Collections.unmodifiableMap(environmentVariables);
                    }
                }
                switch (this.links$key == null ? 0 : this.links$key.size()) {
                    case 0: {
                        links = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        links = Collections.singletonMap(this.links$key.get(0), this.links$value.get(0));
                        break;
                    }
                    default: {
                        links = new LinkedHashMap(this.links$key.size() < 0x40000000 ? 1 + this.links$key.size() + (this.links$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.links$key.size(); ++$i) {
                            links.put(this.links$key.get($i), this.links$value.get($i));
                        }
                        links = Collections.unmodifiableMap(links);
                    }
                }
                switch (this.results$key == null ? 0 : this.results$key.size()) {
                    case 0: {
                        results = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        results = Collections.singletonMap(this.results$key.get(0), this.results$value.get(0));
                        break;
                    }
                    default: {
                        results = new LinkedHashMap(this.results$key.size() < 0x40000000 ? 1 + this.results$key.size() + (this.results$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.results$key.size(); ++$i) {
                            results.put(this.results$key.get($i), this.results$value.get($i));
                        }
                        results = Collections.unmodifiableMap(results);
                    }
                }
                return new Resource(this.createdAt, this.diskLimit, environmentVariables, this.error, this.lifecycle, this.id, links, this.memoryLimit, results, this.state, this.updatedAt);
            }

            public String toString() {
                return "ListApplicationDropletsResponse.Resource.ResourceBuilder(createdAt=" + this.createdAt + ", diskLimit=" + this.diskLimit + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", error=" + this.error + ", lifecycle=" + this.lifecycle + ", id=" + this.id + ", links$key=" + this.links$key + ", links$value=" + this.links$value + ", memoryLimit=" + this.memoryLimit + ", results$key=" + this.results$key + ", results$value=" + this.results$value + ", state=" + this.state + ", updatedAt=" + this.updatedAt + ")";
            }
        }
    }
}

