/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.PaginatedResponse;
import org.cloudfoundry.client.v3.packages.Package;

public final class ListApplicationPackagesResponse
extends PaginatedResponse<Resource> {
    ListApplicationPackagesResponse(@JsonProperty(value="pagination") PaginatedResponse.Pagination pagination, @JsonProperty(value="resources") List<Resource> resources) {
        super(pagination, resources);
    }

    public static ListApplicationPackagesResponseBuilder builder() {
        return new ListApplicationPackagesResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationPackagesResponse)) {
            return false;
        }
        ListApplicationPackagesResponse other = (ListApplicationPackagesResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationPackagesResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationPackagesResponse(super=" + super.toString() + ")";
    }

    public static class ListApplicationPackagesResponseBuilder {
        private PaginatedResponse.Pagination pagination;
        private ArrayList<Resource> resources;

        ListApplicationPackagesResponseBuilder() {
        }

        public ListApplicationPackagesResponseBuilder pagination(PaginatedResponse.Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public ListApplicationPackagesResponseBuilder resource(Resource resource) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.add(resource);
            return this;
        }

        public ListApplicationPackagesResponseBuilder resources(Collection<? extends Resource> resources) {
            if (this.resources == null) {
                this.resources = new ArrayList();
            }
            this.resources.addAll(resources);
            return this;
        }

        public ListApplicationPackagesResponse build() {
            List<Resource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
                case 0: {
                    resources = Collections.emptyList();
                    break;
                }
                case 1: {
                    resources = Collections.singletonList(this.resources.get(0));
                    break;
                }
                default: {
                    resources = Collections.unmodifiableList(new ArrayList<Resource>(this.resources));
                }
            }
            return new ListApplicationPackagesResponse(this.pagination, resources);
        }

        public String toString() {
            return "ListApplicationPackagesResponse.ListApplicationPackagesResponseBuilder(pagination=" + this.pagination + ", resources=" + this.resources + ")";
        }
    }

    public static final class Resource
    extends Package {
        Resource(@JsonProperty(value="created_at") String createdAt, @JsonProperty(value="data") Map<String, Object> datas, @JsonProperty(value="guid") String id, @JsonProperty(value="links") Map<String, Link> links, @JsonProperty(value="state") String state, @JsonProperty(value="type") String type, @JsonProperty(value="updated_at") String updatedAt) {
            super(createdAt, datas, id, links, state, type, updatedAt);
        }

        public static ResourceBuilder builder() {
            return new ResourceBuilder();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + super.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return "ListApplicationPackagesResponse.Resource(super=" + super.toString() + ")";
        }

        public static class ResourceBuilder {
            private String createdAt;
            private ArrayList<String> datas$key;
            private ArrayList<Object> datas$value;
            private String id;
            private ArrayList<String> links$key;
            private ArrayList<Link> links$value;
            private String state;
            private String type;
            private String updatedAt;

            ResourceBuilder() {
            }

            public ResourceBuilder createdAt(String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public ResourceBuilder data(String dataKey, Object dataValue) {
                if (this.datas$key == null) {
                    this.datas$key = new ArrayList();
                    this.datas$value = new ArrayList();
                }
                this.datas$key.add(dataKey);
                this.datas$value.add(dataValue);
                return this;
            }

            public ResourceBuilder datas(Map<? extends String, ? extends Object> datas) {
                if (this.datas$key == null) {
                    this.datas$key = new ArrayList();
                    this.datas$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : datas.entrySet()) {
                    this.datas$key.add($lombokEntry.getKey());
                    this.datas$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ResourceBuilder id(String id) {
                this.id = id;
                return this;
            }

            public ResourceBuilder link(String linkKey, Link linkValue) {
                if (this.links$key == null) {
                    this.links$key = new ArrayList();
                    this.links$value = new ArrayList();
                }
                this.links$key.add(linkKey);
                this.links$value.add(linkValue);
                return this;
            }

            public ResourceBuilder links(Map<? extends String, ? extends Link> links) {
                if (this.links$key == null) {
                    this.links$key = new ArrayList();
                    this.links$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Link> $lombokEntry : links.entrySet()) {
                    this.links$key.add($lombokEntry.getKey());
                    this.links$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ResourceBuilder state(String state) {
                this.state = state;
                return this;
            }

            public ResourceBuilder type(String type) {
                this.type = type;
                return this;
            }

            public ResourceBuilder updatedAt(String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Resource build() {
                Map<String, Link> links;
                Map<String, Object> datas;
                switch (this.datas$key == null ? 0 : this.datas$key.size()) {
                    case 0: {
                        datas = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        datas = Collections.singletonMap(this.datas$key.get(0), this.datas$value.get(0));
                        break;
                    }
                    default: {
                        datas = new LinkedHashMap(this.datas$key.size() < 0x40000000 ? 1 + this.datas$key.size() + (this.datas$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.datas$key.size(); ++$i) {
                            datas.put(this.datas$key.get($i), this.datas$value.get($i));
                        }
                        datas = Collections.unmodifiableMap(datas);
                    }
                }
                switch (this.links$key == null ? 0 : this.links$key.size()) {
                    case 0: {
                        links = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        links = Collections.singletonMap(this.links$key.get(0), this.links$value.get(0));
                        break;
                    }
                    default: {
                        links = new LinkedHashMap(this.links$key.size() < 0x40000000 ? 1 + this.links$key.size() + (this.links$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.links$key.size(); ++$i) {
                            links.put(this.links$key.get($i), this.links$value.get($i));
                        }
                        links = Collections.unmodifiableMap(links);
                    }
                }
                return new Resource(this.createdAt, datas, this.id, links, this.state, this.type, this.updatedAt);
            }

            public String toString() {
                return "ListApplicationPackagesResponse.Resource.ResourceBuilder(createdAt=" + this.createdAt + ", datas$key=" + this.datas$key + ", datas$value=" + this.datas$value + ", id=" + this.id + ", links$key=" + this.links$key + ", links$value=" + this.links$value + ", state=" + this.state + ", type=" + this.type + ", updatedAt=" + this.updatedAt + ")";
            }
        }
    }
}

