/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.PaginatedRequest;

public final class ListApplicationProcessesRequest
extends PaginatedRequest
implements Validatable {
    private final String applicationId;

    ListApplicationProcessesRequest(Integer page, Integer perPage, String applicationId) {
        super(page, perPage);
        this.applicationId = applicationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = this.isPaginatedRequestValid();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static ListApplicationProcessesRequestBuilder builder() {
        return new ListApplicationProcessesRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationProcessesRequest)) {
            return false;
        }
        ListApplicationProcessesRequest other = (ListApplicationProcessesRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        return !(this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationProcessesRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationProcessesRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    public static class ListApplicationProcessesRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String applicationId;

        ListApplicationProcessesRequestBuilder() {
        }

        public ListApplicationProcessesRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationProcessesRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationProcessesRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ListApplicationProcessesRequest build() {
            return new ListApplicationProcessesRequest(this.page, this.perPage, this.applicationId);
        }

        public String toString() {
            return "ListApplicationProcessesRequest.ListApplicationProcessesRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", applicationId=" + this.applicationId + ")";
        }
    }
}

