/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;

public final class ListApplicationsRequest
extends PaginatedAndSortedRequest
implements Validatable {
    private final List<String> ids;
    private final List<String> names;
    private final List<String> organizationIds;
    private final List<String> spaceIds;

    ListApplicationsRequest(Integer page, Integer perPage, String orderBy, List<String> ids, List<String> names, List<String> organizationIds, List<String> spaceIds) {
        super(page, perPage, orderBy);
        this.ids = ids;
        this.names = names;
        this.organizationIds = organizationIds;
        this.spaceIds = spaceIds;
    }

    @Override
    public ValidationResult isValid() {
        return this.isPaginatedAndSortedRequestValid().build();
    }

    public static ListApplicationsRequestBuilder builder() {
        return new ListApplicationsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$ids = this.getIds();
        List<String> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        List<String> this$names = this.getNames();
        List<String> other$names = other.getNames();
        if (this$names == null ? other$names != null : !((Object)this$names).equals(other$names)) {
            return false;
        }
        List<String> this$organizationIds = this.getOrganizationIds();
        List<String> other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds)) {
            return false;
        }
        List<String> this$spaceIds = this.getSpaceIds();
        List<String> other$spaceIds = other.getSpaceIds();
        return !(this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListApplicationsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        List<String> $names = this.getNames();
        result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
        List<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        List<String> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListApplicationsRequest(super=" + super.toString() + ", ids=" + this.getIds() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ", spaceIds=" + this.getSpaceIds() + ")";
    }

    @FilterParameter(value="guids")
    public List<String> getIds() {
        return this.ids;
    }

    @FilterParameter(value="names")
    public List<String> getNames() {
        return this.names;
    }

    @FilterParameter(value="organization_guids")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @FilterParameter(value="space_guids")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    public static class ListApplicationsRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String orderBy;
        private ArrayList<String> ids;
        private ArrayList<String> names;
        private ArrayList<String> organizationIds;
        private ArrayList<String> spaceIds;

        ListApplicationsRequestBuilder() {
        }

        public ListApplicationsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListApplicationsRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListApplicationsRequestBuilder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public ListApplicationsRequestBuilder id(String id) {
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.add(id);
            return this;
        }

        public ListApplicationsRequestBuilder ids(Collection<? extends String> ids) {
            if (this.ids == null) {
                this.ids = new ArrayList();
            }
            this.ids.addAll(ids);
            return this;
        }

        public ListApplicationsRequestBuilder name(String name) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.add(name);
            return this;
        }

        public ListApplicationsRequestBuilder names(Collection<? extends String> names) {
            if (this.names == null) {
                this.names = new ArrayList();
            }
            this.names.addAll(names);
            return this;
        }

        public ListApplicationsRequestBuilder organizationId(String organizationId) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.add(organizationId);
            return this;
        }

        public ListApplicationsRequestBuilder organizationIds(Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) {
                this.organizationIds = new ArrayList();
            }
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        public ListApplicationsRequestBuilder spaceId(String spaceId) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.add(spaceId);
            return this;
        }

        public ListApplicationsRequestBuilder spaceIds(Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) {
                this.spaceIds = new ArrayList();
            }
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        public ListApplicationsRequest build() {
            List<String> spaceIds;
            List<String> organizationIds;
            List<String> names;
            List<String> ids;
            switch (this.ids == null ? 0 : this.ids.size()) {
                case 0: {
                    ids = Collections.emptyList();
                    break;
                }
                case 1: {
                    ids = Collections.singletonList(this.ids.get(0));
                    break;
                }
                default: {
                    ids = Collections.unmodifiableList(new ArrayList<String>(this.ids));
                }
            }
            switch (this.names == null ? 0 : this.names.size()) {
                case 0: {
                    names = Collections.emptyList();
                    break;
                }
                case 1: {
                    names = Collections.singletonList(this.names.get(0));
                    break;
                }
                default: {
                    names = Collections.unmodifiableList(new ArrayList<String>(this.names));
                }
            }
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
                case 0: {
                    organizationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    organizationIds = Collections.singletonList(this.organizationIds.get(0));
                    break;
                }
                default: {
                    organizationIds = Collections.unmodifiableList(new ArrayList<String>(this.organizationIds));
                }
            }
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
                case 0: {
                    spaceIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    spaceIds = Collections.singletonList(this.spaceIds.get(0));
                    break;
                }
                default: {
                    spaceIds = Collections.unmodifiableList(new ArrayList<String>(this.spaceIds));
                }
            }
            return new ListApplicationsRequest(this.page, this.perPage, this.orderBy, ids, names, organizationIds, spaceIds);
        }

        public String toString() {
            return "ListApplicationsRequest.ListApplicationsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", ids=" + this.ids + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ")";
        }
    }
}

