/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class ScaleApplicationRequest
implements Validatable {
    private final String applicationId;
    private final Integer diskInMb;
    private final Integer instances;
    private final Integer memoryInMb;
    private final String type;

    ScaleApplicationRequest(String applicationId, Integer diskInMb, Integer instances, Integer memoryInMb, String type) {
        this.applicationId = applicationId;
        this.diskInMb = diskInMb;
        this.instances = instances;
        this.memoryInMb = memoryInMb;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    public static ScaleApplicationRequestBuilder builder() {
        return new ScaleApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleApplicationRequest)) {
            return false;
        }
        ScaleApplicationRequest other = (ScaleApplicationRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Integer this$diskInMb = this.getDiskInMb();
        Integer other$diskInMb = other.getDiskInMb();
        if (this$diskInMb == null ? other$diskInMb != null : !((Object)this$diskInMb).equals(other$diskInMb)) {
            return false;
        }
        Integer this$instances = this.getInstances();
        Integer other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Integer this$memoryInMb = this.getMemoryInMb();
        Integer other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !((Object)this$memoryInMb).equals(other$memoryInMb)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Integer $diskInMb = this.getDiskInMb();
        result = result * 59 + ($diskInMb == null ? 43 : ((Object)$diskInMb).hashCode());
        Integer $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Integer $memoryInMb = this.getMemoryInMb();
        result = result * 59 + ($memoryInMb == null ? 43 : ((Object)$memoryInMb).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "ScaleApplicationRequest(applicationId=" + this.getApplicationId() + ", diskInMb=" + this.getDiskInMb() + ", instances=" + this.getInstances() + ", memoryInMb=" + this.getMemoryInMb() + ", type=" + this.getType() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="disk_in_mb")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @JsonProperty(value="instances")
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @JsonIgnore
    public String getType() {
        return this.type;
    }

    public static class ScaleApplicationRequestBuilder {
        private String applicationId;
        private Integer diskInMb;
        private Integer instances;
        private Integer memoryInMb;
        private String type;

        ScaleApplicationRequestBuilder() {
        }

        public ScaleApplicationRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public ScaleApplicationRequestBuilder diskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public ScaleApplicationRequestBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public ScaleApplicationRequestBuilder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public ScaleApplicationRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ScaleApplicationRequest build() {
            return new ScaleApplicationRequest(this.applicationId, this.diskInMb, this.instances, this.memoryInMb, this.type);
        }

        public String toString() {
            return "ScaleApplicationRequest.ScaleApplicationRequestBuilder(applicationId=" + this.applicationId + ", diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", type=" + this.type + ")";
        }
    }
}

