/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.Lifecycle;

public final class UpdateApplicationRequest
implements Validatable {
    private final String applicationId;
    private final Map<String, String> environmentVariables;
    private final Lifecycle lifecycle;
    private final String name;

    UpdateApplicationRequest(String applicationId, Map<String, String> environmentVariables, Lifecycle lifecycle, String name) {
        this.applicationId = applicationId;
        this.environmentVariables = environmentVariables;
        this.lifecycle = lifecycle;
        this.name = name;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    public static UpdateApplicationRequestBuilder builder() {
        return new UpdateApplicationRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Map<String, String> this$environmentVariables = this.getEnvironmentVariables();
        Map<String, String> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Map<String, String> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateApplicationRequest(applicationId=" + this.getApplicationId() + ", environmentVariables=" + this.getEnvironmentVariables() + ", lifecycle=" + this.getLifecycle() + ", name=" + this.getName() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="environment_variables")
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public static class UpdateApplicationRequestBuilder {
        private String applicationId;
        private ArrayList<String> environmentVariables$key;
        private ArrayList<String> environmentVariables$value;
        private Lifecycle lifecycle;
        private String name;

        UpdateApplicationRequestBuilder() {
        }

        public UpdateApplicationRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public UpdateApplicationRequestBuilder environmentVariable(String environmentVariableKey, String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public UpdateApplicationRequestBuilder environmentVariables(Map<? extends String, ? extends String> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public UpdateApplicationRequestBuilder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public UpdateApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateApplicationRequest build() {
            Map<String, String> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            return new UpdateApplicationRequest(this.applicationId, environmentVariables, this.lifecycle, this.name);
        }

        public String toString() {
            return "UpdateApplicationRequest.UpdateApplicationRequestBuilder(applicationId=" + this.applicationId + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", lifecycle=" + this.lifecycle + ", name=" + this.name + ")";
        }
    }
}

