/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.client.v3.PaginatedAndSortedRequest;

public final class ListDropletsRequest
extends PaginatedAndSortedRequest
implements Validatable {
    private final List<String> applicationIds;
    private final List<String> states;

    ListDropletsRequest(Integer page, Integer perPage, String orderBy, List<String> applicationIds, List<String> states) {
        super(page, perPage, orderBy);
        this.applicationIds = applicationIds;
        this.states = states;
    }

    @Override
    public ValidationResult isValid() {
        return this.isPaginatedAndSortedRequestValid().build();
    }

    public static ListDropletsRequestBuilder builder() {
        return new ListDropletsRequestBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDropletsRequest)) {
            return false;
        }
        ListDropletsRequest other = (ListDropletsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$applicationIds = this.getApplicationIds();
        List<String> other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !((Object)this$applicationIds).equals(other$applicationIds)) {
            return false;
        }
        List<String> this$states = this.getStates();
        List<String> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListDropletsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $applicationIds = this.getApplicationIds();
        result = result * 59 + ($applicationIds == null ? 43 : ((Object)$applicationIds).hashCode());
        List<String> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ListDropletsRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", states=" + this.getStates() + ")";
    }

    @FilterParameter(value="app_guids")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @FilterParameter(value="states")
    public List<String> getStates() {
        return this.states;
    }

    public static class ListDropletsRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String orderBy;
        private ArrayList<String> applicationIds;
        private ArrayList<String> states;

        ListDropletsRequestBuilder() {
        }

        public ListDropletsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public ListDropletsRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListDropletsRequestBuilder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public ListDropletsRequestBuilder applicationId(String applicationId) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.add(applicationId);
            return this;
        }

        public ListDropletsRequestBuilder applicationIds(Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) {
                this.applicationIds = new ArrayList();
            }
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        public ListDropletsRequestBuilder state(String state) {
            if (this.states == null) {
                this.states = new ArrayList();
            }
            this.states.add(state);
            return this;
        }

        public ListDropletsRequestBuilder states(Collection<? extends String> states) {
            if (this.states == null) {
                this.states = new ArrayList();
            }
            this.states.addAll(states);
            return this;
        }

        public ListDropletsRequest build() {
            List<String> states;
            List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
                case 0: {
                    applicationIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    applicationIds = Collections.singletonList(this.applicationIds.get(0));
                    break;
                }
                default: {
                    applicationIds = Collections.unmodifiableList(new ArrayList<String>(this.applicationIds));
                }
            }
            switch (this.states == null ? 0 : this.states.size()) {
                case 0: {
                    states = Collections.emptyList();
                    break;
                }
                case 1: {
                    states = Collections.singletonList(this.states.get(0));
                    break;
                }
                default: {
                    states = Collections.unmodifiableList(new ArrayList<String>(this.states));
                }
            }
            return new ListDropletsRequest(this.page, this.perPage, this.orderBy, applicationIds, states);
        }

        public String toString() {
            return "ListDropletsRequest.ListDropletsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", orderBy=" + this.orderBy + ", applicationIds=" + this.applicationIds + ", states=" + this.states + ")";
        }
    }
}

