/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CopyPackageRequest
implements Validatable {
    private final String applicationId;
    private final String sourcePackageId;

    CopyPackageRequest(String applicationId, String sourcePackageId) {
        this.applicationId = applicationId;
        this.sourcePackageId = sourcePackageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.sourcePackageId == null) {
            builder.message("source package id must be specified");
        }
        return builder.build();
    }

    public static CopyPackageRequestBuilder builder() {
        return new CopyPackageRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyPackageRequest)) {
            return false;
        }
        CopyPackageRequest other = (CopyPackageRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        String this$sourcePackageId = this.getSourcePackageId();
        String other$sourcePackageId = other.getSourcePackageId();
        return !(this$sourcePackageId == null ? other$sourcePackageId != null : !this$sourcePackageId.equals(other$sourcePackageId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        String $sourcePackageId = this.getSourcePackageId();
        result = result * 59 + ($sourcePackageId == null ? 43 : $sourcePackageId.hashCode());
        return result;
    }

    public String toString() {
        return "CopyPackageRequest(applicationId=" + this.getApplicationId() + ", sourcePackageId=" + this.getSourcePackageId() + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @QueryParameter(value="source_package_guid")
    public String getSourcePackageId() {
        return this.sourcePackageId;
    }

    public static class CopyPackageRequestBuilder {
        private String applicationId;
        private String sourcePackageId;

        CopyPackageRequestBuilder() {
        }

        public CopyPackageRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CopyPackageRequestBuilder sourcePackageId(String sourcePackageId) {
            this.sourcePackageId = sourcePackageId;
            return this;
        }

        public CopyPackageRequest build() {
            return new CopyPackageRequest(this.applicationId, this.sourcePackageId);
        }

        public String toString() {
            return "CopyPackageRequest.CopyPackageRequestBuilder(applicationId=" + this.applicationId + ", sourcePackageId=" + this.sourcePackageId + ")";
        }
    }
}

