/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class CreatePackageRequest
implements Validatable {
    private final String applicationId;
    private final Map<String, Object> datas;
    private final PackageType type;

    CreatePackageRequest(String applicationId, Map<String, Object> datas, PackageType type) {
        this.applicationId = applicationId;
        this.datas = datas;
        this.type = type;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.type == null) {
            builder.message("type must be specified");
        }
        return builder.build();
    }

    public static CreatePackageRequestBuilder builder() {
        return new CreatePackageRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest)o;
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Map<String, Object> this$datas = this.getDatas();
        Map<String, Object> other$datas = other.getDatas();
        if (this$datas == null ? other$datas != null : !((Object)this$datas).equals(other$datas)) {
            return false;
        }
        PackageType this$type = this.getType();
        PackageType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Map<String, Object> $datas = this.getDatas();
        result = result * 59 + ($datas == null ? 43 : ((Object)$datas).hashCode());
        PackageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "CreatePackageRequest(applicationId=" + this.getApplicationId() + ", datas=" + this.getDatas() + ", type=" + (Object)((Object)this.getType()) + ")";
    }

    @JsonIgnore
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="data")
    public Map<String, Object> getDatas() {
        return this.datas;
    }

    @JsonProperty(value="type")
    public PackageType getType() {
        return this.type;
    }

    public static class CreatePackageRequestBuilder {
        private String applicationId;
        private ArrayList<String> datas$key;
        private ArrayList<Object> datas$value;
        private PackageType type;

        CreatePackageRequestBuilder() {
        }

        public CreatePackageRequestBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public CreatePackageRequestBuilder data(String dataKey, Object dataValue) {
            if (this.datas$key == null) {
                this.datas$key = new ArrayList();
                this.datas$value = new ArrayList();
            }
            this.datas$key.add(dataKey);
            this.datas$value.add(dataValue);
            return this;
        }

        public CreatePackageRequestBuilder datas(Map<? extends String, ? extends Object> datas) {
            if (this.datas$key == null) {
                this.datas$key = new ArrayList();
                this.datas$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : datas.entrySet()) {
                this.datas$key.add($lombokEntry.getKey());
                this.datas$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CreatePackageRequestBuilder type(PackageType type) {
            this.type = type;
            return this;
        }

        public CreatePackageRequest build() {
            Map<String, Object> datas;
            switch (this.datas$key == null ? 0 : this.datas$key.size()) {
                case 0: {
                    datas = Collections.emptyMap();
                    break;
                }
                case 1: {
                    datas = Collections.singletonMap(this.datas$key.get(0), this.datas$value.get(0));
                    break;
                }
                default: {
                    datas = new LinkedHashMap(this.datas$key.size() < 0x40000000 ? 1 + this.datas$key.size() + (this.datas$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.datas$key.size(); ++$i) {
                        datas.put(this.datas$key.get($i), this.datas$value.get($i));
                    }
                    datas = Collections.unmodifiableMap(datas);
                }
            }
            return new CreatePackageRequest(this.applicationId, datas, this.type);
        }

        public String toString() {
            return "CreatePackageRequest.CreatePackageRequestBuilder(applicationId=" + this.applicationId + ", datas$key=" + this.datas$key + ", datas$value=" + this.datas$value + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum PackageType {
        BITS,
        DOCKER;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

