/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class DeletePackageRequest
implements Validatable {
    private final String packageId;

    DeletePackageRequest(String packageId) {
        this.packageId = packageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.packageId == null) {
            builder.message("package id must be specified");
        }
        return builder.build();
    }

    public static DeletePackageRequestBuilder builder() {
        return new DeletePackageRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeletePackageRequest)) {
            return false;
        }
        DeletePackageRequest other = (DeletePackageRequest)o;
        String this$packageId = this.getPackageId();
        String other$packageId = other.getPackageId();
        return !(this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }

    public String toString() {
        return "DeletePackageRequest(packageId=" + this.getPackageId() + ")";
    }

    @JsonIgnore
    public String getPackageId() {
        return this.packageId;
    }

    public static class DeletePackageRequestBuilder {
        private String packageId;

        DeletePackageRequestBuilder() {
        }

        public DeletePackageRequestBuilder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public DeletePackageRequest build() {
            return new DeletePackageRequest(this.packageId);
        }

        public String toString() {
            return "DeletePackageRequest.DeletePackageRequestBuilder(packageId=" + this.packageId + ")";
        }
    }
}

