/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.Lifecycle;

public final class StagePackageRequest
implements Validatable {
    private final Integer diskLimit;
    private final Map<String, Object> environmentVariables;
    private final Lifecycle lifecycle;
    private final Integer memoryLimit;
    private final String packageId;

    StagePackageRequest(Integer diskLimit, Map<String, Object> environmentVariables, Lifecycle lifecycle, Integer memoryLimit, String packageId) {
        this.diskLimit = diskLimit;
        this.environmentVariables = environmentVariables;
        this.lifecycle = lifecycle;
        this.memoryLimit = memoryLimit;
        this.packageId = packageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.packageId == null) {
            builder.message("package id must be specified");
        }
        return builder.build();
    }

    public static StagePackageRequestBuilder builder() {
        return new StagePackageRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StagePackageRequest)) {
            return false;
        }
        StagePackageRequest other = (StagePackageRequest)o;
        Integer this$diskLimit = this.getDiskLimit();
        Integer other$diskLimit = other.getDiskLimit();
        if (this$diskLimit == null ? other$diskLimit != null : !((Object)this$diskLimit).equals(other$diskLimit)) {
            return false;
        }
        Map<String, Object> this$environmentVariables = this.getEnvironmentVariables();
        Map<String, Object> other$environmentVariables = other.getEnvironmentVariables();
        if (this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)this$lifecycle).equals(other$lifecycle)) {
            return false;
        }
        Integer this$memoryLimit = this.getMemoryLimit();
        Integer other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !((Object)this$memoryLimit).equals(other$memoryLimit)) {
            return false;
        }
        String this$packageId = this.getPackageId();
        String other$packageId = other.getPackageId();
        return !(this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $diskLimit = this.getDiskLimit();
        result = result * 59 + ($diskLimit == null ? 43 : ((Object)$diskLimit).hashCode());
        Map<String, Object> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)$lifecycle).hashCode());
        Integer $memoryLimit = this.getMemoryLimit();
        result = result * 59 + ($memoryLimit == null ? 43 : ((Object)$memoryLimit).hashCode());
        String $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }

    public String toString() {
        return "StagePackageRequest(diskLimit=" + this.getDiskLimit() + ", environmentVariables=" + this.getEnvironmentVariables() + ", lifecycle=" + this.getLifecycle() + ", memoryLimit=" + this.getMemoryLimit() + ", packageId=" + this.getPackageId() + ")";
    }

    @JsonProperty(value="disk_limit")
    public Integer getDiskLimit() {
        return this.diskLimit;
    }

    @JsonProperty(value="environment_variables")
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @JsonProperty(value="lifecycle")
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @JsonProperty(value="memory_limit")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    @JsonIgnore
    public String getPackageId() {
        return this.packageId;
    }

    public static class StagePackageRequestBuilder {
        private Integer diskLimit;
        private ArrayList<String> environmentVariables$key;
        private ArrayList<Object> environmentVariables$value;
        private Lifecycle lifecycle;
        private Integer memoryLimit;
        private String packageId;

        StagePackageRequestBuilder() {
        }

        public StagePackageRequestBuilder diskLimit(Integer diskLimit) {
            this.diskLimit = diskLimit;
            return this;
        }

        public StagePackageRequestBuilder environmentVariable(String environmentVariableKey, Object environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public StagePackageRequestBuilder environmentVariables(Map<? extends String, ? extends Object> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public StagePackageRequestBuilder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public StagePackageRequestBuilder memoryLimit(Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        public StagePackageRequestBuilder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public StagePackageRequest build() {
            Map<String, Object> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            return new StagePackageRequest(this.diskLimit, environmentVariables, this.lifecycle, this.memoryLimit, this.packageId);
        }

        public String toString() {
            return "StagePackageRequest.StagePackageRequestBuilder(diskLimit=" + this.diskLimit + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", lifecycle=" + this.lifecycle + ", memoryLimit=" + this.memoryLimit + ", packageId=" + this.packageId + ")";
        }
    }
}

