/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UploadPackageRequest
implements Validatable {
    private final InputStream bits;
    private final String packageId;

    UploadPackageRequest(InputStream bits, String packageId) {
        this.bits = bits;
        this.packageId = packageId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.bits == null) {
            builder.message("bits must be specified");
        }
        if (this.packageId == null) {
            builder.message("package id must be specified");
        }
        return builder.build();
    }

    public static UploadPackageRequestBuilder builder() {
        return new UploadPackageRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadPackageRequest)) {
            return false;
        }
        UploadPackageRequest other = (UploadPackageRequest)o;
        InputStream this$bits = this.getBits();
        InputStream other$bits = other.getBits();
        if (this$bits == null ? other$bits != null : !this$bits.equals(other$bits)) {
            return false;
        }
        String this$packageId = this.getPackageId();
        String other$packageId = other.getPackageId();
        return !(this$packageId == null ? other$packageId != null : !this$packageId.equals(other$packageId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $bits = this.getBits();
        result = result * 59 + ($bits == null ? 43 : $bits.hashCode());
        String $packageId = this.getPackageId();
        result = result * 59 + ($packageId == null ? 43 : $packageId.hashCode());
        return result;
    }

    public String toString() {
        return "UploadPackageRequest(bits=" + this.getBits() + ", packageId=" + this.getPackageId() + ")";
    }

    @JsonIgnore
    public InputStream getBits() {
        return this.bits;
    }

    @JsonIgnore
    public String getPackageId() {
        return this.packageId;
    }

    public static class UploadPackageRequestBuilder {
        private InputStream bits;
        private String packageId;

        UploadPackageRequestBuilder() {
        }

        public UploadPackageRequestBuilder bits(InputStream bits) {
            this.bits = bits;
            return this;
        }

        public UploadPackageRequestBuilder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public UploadPackageRequest build() {
            return new UploadPackageRequest(this.bits, this.packageId);
        }

        public String toString() {
            return "UploadPackageRequest.UploadPackageRequestBuilder(bits=" + this.bits + ", packageId=" + this.packageId + ")";
        }
    }
}

