/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v3.PaginatedRequest;

public final class GetProcessDetailedStatisticsRequest
extends PaginatedRequest
implements Validatable {
    private final String processId;

    GetProcessDetailedStatisticsRequest(Integer page, Integer perPage, String processId) {
        super(page, perPage);
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    public static GetProcessDetailedStatisticsRequestBuilder builder() {
        return new GetProcessDetailedStatisticsRequestBuilder();
    }

    @Override
    public String toString() {
        return "GetProcessDetailedStatisticsRequest(processId=" + this.getProcessId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetProcessDetailedStatisticsRequest)) {
            return false;
        }
        GetProcessDetailedStatisticsRequest other = (GetProcessDetailedStatisticsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetProcessDetailedStatisticsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public static class GetProcessDetailedStatisticsRequestBuilder {
        private Integer page;
        private Integer perPage;
        private String processId;

        GetProcessDetailedStatisticsRequestBuilder() {
        }

        public GetProcessDetailedStatisticsRequestBuilder page(Integer page) {
            this.page = page;
            return this;
        }

        public GetProcessDetailedStatisticsRequestBuilder perPage(Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public GetProcessDetailedStatisticsRequestBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public GetProcessDetailedStatisticsRequest build() {
            return new GetProcessDetailedStatisticsRequest(this.page, this.perPage, this.processId);
        }

        public String toString() {
            return "GetProcessDetailedStatisticsRequest.GetProcessDetailedStatisticsRequestBuilder(page=" + this.page + ", perPage=" + this.perPage + ", processId=" + this.processId + ")";
        }
    }
}

