/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class GetProcessRequest
implements Validatable {
    private final String processId;

    GetProcessRequest(String processId) {
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    public static GetProcessRequestBuilder builder() {
        return new GetProcessRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetProcessRequest)) {
            return false;
        }
        GetProcessRequest other = (GetProcessRequest)o;
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    public String toString() {
        return "GetProcessRequest(processId=" + this.getProcessId() + ")";
    }

    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public static class GetProcessRequestBuilder {
        private String processId;

        GetProcessRequestBuilder() {
        }

        public GetProcessRequestBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public GetProcessRequest build() {
            return new GetProcessRequest(this.processId);
        }

        public String toString() {
            return "GetProcessRequest.GetProcessRequestBuilder(processId=" + this.processId + ")";
        }
    }
}

