/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.processes.Process;

public final class GetProcessResponse
extends Process {
    GetProcessResponse(@JsonProperty(value="command") String command, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="disk_in_mb") Integer diskInMb, @JsonProperty(value="guid") String id, @JsonProperty(value="instances") Integer instances, @JsonProperty(value="links") Map<String, Link> links, @JsonProperty(value="memory_in_mb") Integer memoryInMb, @JsonProperty(value="type") String type, @JsonProperty(value="updated_at") String updatedAt) {
        super(command, createdAt, diskInMb, id, instances, links, memoryInMb, type, updatedAt);
    }

    public static GetProcessResponseBuilder builder() {
        return new GetProcessResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetProcessResponse)) {
            return false;
        }
        GetProcessResponse other = (GetProcessResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GetProcessResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "GetProcessResponse(super=" + super.toString() + ")";
    }

    public static class GetProcessResponseBuilder {
        private String command;
        private String createdAt;
        private Integer diskInMb;
        private String id;
        private Integer instances;
        private ArrayList<String> links$key;
        private ArrayList<Link> links$value;
        private Integer memoryInMb;
        private String type;
        private String updatedAt;

        GetProcessResponseBuilder() {
        }

        public GetProcessResponseBuilder command(String command) {
            this.command = command;
            return this;
        }

        public GetProcessResponseBuilder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public GetProcessResponseBuilder diskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public GetProcessResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public GetProcessResponseBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public GetProcessResponseBuilder link(String linkKey, Link linkValue) {
            if (this.links$key == null) {
                this.links$key = new ArrayList();
                this.links$value = new ArrayList();
            }
            this.links$key.add(linkKey);
            this.links$value.add(linkValue);
            return this;
        }

        public GetProcessResponseBuilder links(Map<? extends String, ? extends Link> links) {
            if (this.links$key == null) {
                this.links$key = new ArrayList();
                this.links$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Link> $lombokEntry : links.entrySet()) {
                this.links$key.add($lombokEntry.getKey());
                this.links$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public GetProcessResponseBuilder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public GetProcessResponseBuilder type(String type) {
            this.type = type;
            return this;
        }

        public GetProcessResponseBuilder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public GetProcessResponse build() {
            Map<String, Link> links;
            switch (this.links$key == null ? 0 : this.links$key.size()) {
                case 0: {
                    links = Collections.emptyMap();
                    break;
                }
                case 1: {
                    links = Collections.singletonMap(this.links$key.get(0), this.links$value.get(0));
                    break;
                }
                default: {
                    links = new LinkedHashMap(this.links$key.size() < 0x40000000 ? 1 + this.links$key.size() + (this.links$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.links$key.size(); ++$i) {
                        links.put(this.links$key.get($i), this.links$value.get($i));
                    }
                    links = Collections.unmodifiableMap(links);
                }
            }
            return new GetProcessResponse(this.command, this.createdAt, this.diskInMb, this.id, this.instances, links, this.memoryInMb, this.type, this.updatedAt);
        }

        public String toString() {
            return "GetProcessResponse.GetProcessResponseBuilder(command=" + this.command + ", createdAt=" + this.createdAt + ", diskInMb=" + this.diskInMb + ", id=" + this.id + ", instances=" + this.instances + ", links$key=" + this.links$key + ", links$value=" + this.links$value + ", memoryInMb=" + this.memoryInMb + ", type=" + this.type + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

