/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class ScaleProcessRequest
implements Validatable {
    private final Integer diskInMb;
    private final Integer instances;
    private final Integer memoryInMb;
    private final String processId;

    ScaleProcessRequest(Integer diskInMb, Integer instances, Integer memoryInMb, String processId) {
        this.diskInMb = diskInMb;
        this.instances = instances;
        this.memoryInMb = memoryInMb;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    public static ScaleProcessRequestBuilder builder() {
        return new ScaleProcessRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScaleProcessRequest)) {
            return false;
        }
        ScaleProcessRequest other = (ScaleProcessRequest)o;
        Integer this$diskInMb = this.getDiskInMb();
        Integer other$diskInMb = other.getDiskInMb();
        if (this$diskInMb == null ? other$diskInMb != null : !((Object)this$diskInMb).equals(other$diskInMb)) {
            return false;
        }
        Integer this$instances = this.getInstances();
        Integer other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances)) {
            return false;
        }
        Integer this$memoryInMb = this.getMemoryInMb();
        Integer other$memoryInMb = other.getMemoryInMb();
        if (this$memoryInMb == null ? other$memoryInMb != null : !((Object)this$memoryInMb).equals(other$memoryInMb)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $diskInMb = this.getDiskInMb();
        result = result * 59 + ($diskInMb == null ? 43 : ((Object)$diskInMb).hashCode());
        Integer $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 43 : ((Object)$instances).hashCode());
        Integer $memoryInMb = this.getMemoryInMb();
        result = result * 59 + ($memoryInMb == null ? 43 : ((Object)$memoryInMb).hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    public String toString() {
        return "ScaleProcessRequest(diskInMb=" + this.getDiskInMb() + ", instances=" + this.getInstances() + ", memoryInMb=" + this.getMemoryInMb() + ", processId=" + this.getProcessId() + ")";
    }

    @JsonProperty(value="disk_in_mb")
    public Integer getDiskInMb() {
        return this.diskInMb;
    }

    @JsonProperty(value="instances")
    public Integer getInstances() {
        return this.instances;
    }

    @JsonProperty(value="memory_in_mb")
    public Integer getMemoryInMb() {
        return this.memoryInMb;
    }

    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public static class ScaleProcessRequestBuilder {
        private Integer diskInMb;
        private Integer instances;
        private Integer memoryInMb;
        private String processId;

        ScaleProcessRequestBuilder() {
        }

        public ScaleProcessRequestBuilder diskInMb(Integer diskInMb) {
            this.diskInMb = diskInMb;
            return this;
        }

        public ScaleProcessRequestBuilder instances(Integer instances) {
            this.instances = instances;
            return this;
        }

        public ScaleProcessRequestBuilder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public ScaleProcessRequestBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public ScaleProcessRequest build() {
            return new ScaleProcessRequest(this.diskInMb, this.instances, this.memoryInMb, this.processId);
        }

        public String toString() {
            return "ScaleProcessRequest.ScaleProcessRequestBuilder(diskInMb=" + this.diskInMb + ", instances=" + this.instances + ", memoryInMb=" + this.memoryInMb + ", processId=" + this.processId + ")";
        }
    }
}

