/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class TerminateProcessInstanceRequest
implements Validatable {
    private final String index;
    private final String processId;

    TerminateProcessInstanceRequest(String index, String processId) {
        this.index = index;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.index == null) {
            builder.message("index must be specified");
        }
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        return builder.build();
    }

    public static TerminateProcessInstanceRequestBuilder builder() {
        return new TerminateProcessInstanceRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TerminateProcessInstanceRequest)) {
            return false;
        }
        TerminateProcessInstanceRequest other = (TerminateProcessInstanceRequest)o;
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    public String toString() {
        return "TerminateProcessInstanceRequest(index=" + this.getIndex() + ", processId=" + this.getProcessId() + ")";
    }

    @JsonIgnore
    public String getIndex() {
        return this.index;
    }

    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public static class TerminateProcessInstanceRequestBuilder {
        private String index;
        private String processId;

        TerminateProcessInstanceRequestBuilder() {
        }

        public TerminateProcessInstanceRequestBuilder index(String index) {
            this.index = index;
            return this;
        }

        public TerminateProcessInstanceRequestBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public TerminateProcessInstanceRequest build() {
            return new TerminateProcessInstanceRequest(this.index, this.processId);
        }

        public String toString() {
            return "TerminateProcessInstanceRequest.TerminateProcessInstanceRequestBuilder(index=" + this.index + ", processId=" + this.processId + ")";
        }
    }
}

