/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

public final class UpdateProcessRequest
implements Validatable {
    private final String command;
    private final String processId;

    UpdateProcessRequest(String command, String processId) {
        this.command = command;
        this.processId = processId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.processId == null) {
            builder.message("process id must be specified");
        }
        if (this.command == null) {
            builder.message("command must be specified");
        }
        return builder.build();
    }

    public static UpdateProcessRequestBuilder builder() {
        return new UpdateProcessRequestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateProcessRequest)) {
            return false;
        }
        UpdateProcessRequest other = (UpdateProcessRequest)o;
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$processId = this.getProcessId();
        String other$processId = other.getProcessId();
        return !(this$processId == null ? other$processId != null : !this$processId.equals(other$processId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $processId = this.getProcessId();
        result = result * 59 + ($processId == null ? 43 : $processId.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateProcessRequest(command=" + this.getCommand() + ", processId=" + this.getProcessId() + ")";
    }

    @JsonProperty(value="command")
    public String getCommand() {
        return this.command;
    }

    @JsonIgnore
    public String getProcessId() {
        return this.processId;
    }

    public static class UpdateProcessRequestBuilder {
        private String command;
        private String processId;

        UpdateProcessRequestBuilder() {
        }

        public UpdateProcessRequestBuilder command(String command) {
            this.command = command;
            return this;
        }

        public UpdateProcessRequestBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public UpdateProcessRequest build() {
            return new UpdateProcessRequest(this.command, this.processId);
        }

        public String toString() {
            return "UpdateProcessRequest.UpdateProcessRequestBuilder(command=" + this.command + ", processId=" + this.processId + ")";
        }
    }
}

