/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.tasks.Task;

public final class CancelTaskResponse
extends Task {
    CancelTaskResponse(@JsonProperty(value="command") String command, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="environment_variables") Map<String, String> environmentVariables, @JsonProperty(value="guid") String id, @JsonProperty(value="links") Map<String, Link> links, @JsonProperty(value="memory_in_mb") Integer memoryInMb, @JsonProperty(value="name") String name, @JsonProperty(value="result") Map<String, Object> results, @JsonProperty(value="state") String state, @JsonProperty(value="updated_at") String updatedAt) {
        super(command, createdAt, environmentVariables, id, links, memoryInMb, name, results, state, updatedAt);
    }

    public static CancelTaskResponseBuilder builder() {
        return new CancelTaskResponseBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelTaskResponse)) {
            return false;
        }
        CancelTaskResponse other = (CancelTaskResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CancelTaskResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CancelTaskResponse(super=" + super.toString() + ")";
    }

    public static class CancelTaskResponseBuilder {
        private String command;
        private String createdAt;
        private ArrayList<String> environmentVariables$key;
        private ArrayList<String> environmentVariables$value;
        private String id;
        private ArrayList<String> links$key;
        private ArrayList<Link> links$value;
        private Integer memoryInMb;
        private String name;
        private ArrayList<String> results$key;
        private ArrayList<Object> results$value;
        private String state;
        private String updatedAt;

        CancelTaskResponseBuilder() {
        }

        public CancelTaskResponseBuilder command(String command) {
            this.command = command;
            return this;
        }

        public CancelTaskResponseBuilder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public CancelTaskResponseBuilder environmentVariable(String environmentVariableKey, String environmentVariableValue) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            this.environmentVariables$key.add(environmentVariableKey);
            this.environmentVariables$value.add(environmentVariableValue);
            return this;
        }

        public CancelTaskResponseBuilder environmentVariables(Map<? extends String, ? extends String> environmentVariables) {
            if (this.environmentVariables$key == null) {
                this.environmentVariables$key = new ArrayList();
                this.environmentVariables$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : environmentVariables.entrySet()) {
                this.environmentVariables$key.add($lombokEntry.getKey());
                this.environmentVariables$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CancelTaskResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public CancelTaskResponseBuilder link(String linkKey, Link linkValue) {
            if (this.links$key == null) {
                this.links$key = new ArrayList();
                this.links$value = new ArrayList();
            }
            this.links$key.add(linkKey);
            this.links$value.add(linkValue);
            return this;
        }

        public CancelTaskResponseBuilder links(Map<? extends String, ? extends Link> links) {
            if (this.links$key == null) {
                this.links$key = new ArrayList();
                this.links$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Link> $lombokEntry : links.entrySet()) {
                this.links$key.add($lombokEntry.getKey());
                this.links$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CancelTaskResponseBuilder memoryInMb(Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        public CancelTaskResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CancelTaskResponseBuilder result(String resultKey, Object resultValue) {
            if (this.results$key == null) {
                this.results$key = new ArrayList();
                this.results$value = new ArrayList();
            }
            this.results$key.add(resultKey);
            this.results$value.add(resultValue);
            return this;
        }

        public CancelTaskResponseBuilder results(Map<? extends String, ? extends Object> results) {
            if (this.results$key == null) {
                this.results$key = new ArrayList();
                this.results$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : results.entrySet()) {
                this.results$key.add($lombokEntry.getKey());
                this.results$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public CancelTaskResponseBuilder state(String state) {
            this.state = state;
            return this;
        }

        public CancelTaskResponseBuilder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public CancelTaskResponse build() {
            Map<String, Object> results;
            Map<Object, Object> links;
            Map<Object, Object> environmentVariables;
            switch (this.environmentVariables$key == null ? 0 : this.environmentVariables$key.size()) {
                case 0: {
                    environmentVariables = Collections.emptyMap();
                    break;
                }
                case 1: {
                    environmentVariables = Collections.singletonMap(this.environmentVariables$key.get(0), this.environmentVariables$value.get(0));
                    break;
                }
                default: {
                    environmentVariables = new LinkedHashMap(this.environmentVariables$key.size() < 0x40000000 ? 1 + this.environmentVariables$key.size() + (this.environmentVariables$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.environmentVariables$key.size(); ++$i) {
                        environmentVariables.put(this.environmentVariables$key.get($i), this.environmentVariables$value.get($i));
                    }
                    environmentVariables = Collections.unmodifiableMap(environmentVariables);
                }
            }
            switch (this.links$key == null ? 0 : this.links$key.size()) {
                case 0: {
                    links = Collections.emptyMap();
                    break;
                }
                case 1: {
                    links = Collections.singletonMap(this.links$key.get(0), this.links$value.get(0));
                    break;
                }
                default: {
                    links = new LinkedHashMap(this.links$key.size() < 0x40000000 ? 1 + this.links$key.size() + (this.links$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.links$key.size(); ++$i) {
                        links.put(this.links$key.get($i), this.links$value.get($i));
                    }
                    links = Collections.unmodifiableMap(links);
                }
            }
            switch (this.results$key == null ? 0 : this.results$key.size()) {
                case 0: {
                    results = Collections.emptyMap();
                    break;
                }
                case 1: {
                    results = Collections.singletonMap(this.results$key.get(0), this.results$value.get(0));
                    break;
                }
                default: {
                    results = new LinkedHashMap(this.results$key.size() < 0x40000000 ? 1 + this.results$key.size() + (this.results$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.results$key.size(); ++$i) {
                        results.put(this.results$key.get($i), this.results$value.get($i));
                    }
                    results = Collections.unmodifiableMap(results);
                }
            }
            return new CancelTaskResponse(this.command, this.createdAt, environmentVariables, this.id, links, this.memoryInMb, this.name, results, this.state, this.updatedAt);
        }

        public String toString() {
            return "CancelTaskResponse.CancelTaskResponseBuilder(command=" + this.command + ", createdAt=" + this.createdAt + ", environmentVariables$key=" + this.environmentVariables$key + ", environmentVariables$value=" + this.environmentVariables$value + ", id=" + this.id + ", links$key=" + this.links$key + ", links$value=" + this.links$value + ", memoryInMb=" + this.memoryInMb + ", name=" + this.name + ", results$key=" + this.results$key + ", results$value=" + this.results$value + ", state=" + this.state + ", updatedAt=" + this.updatedAt + ")";
        }
    }
}

